/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class SerializerUtil {
    public static String HREF = "href";
    private boolean serializeLinksAsObjects;

    public SerializerUtil(boolean serializeLinksAsObjects) {
        this.serializeLinksAsObjects = serializeLinksAsObjects;
    }

    public ObjectNode serializeLink(ObjectMapper objectMapper, ObjectNode node, String fieldName, String url) {
        if (this.serializeLinksAsObjects) {
            ObjectNode linkNode = objectMapper.createObjectNode();
            linkNode.put(HREF, url);
            node.set(fieldName, (JsonNode)linkNode);
        } else {
            node.put(fieldName, url);
        }
        return node;
    }

    public void serializeLink(JsonGenerator gen, String fieldName, String url) throws IOException {
        if (this.serializeLinksAsObjects) {
            gen.writeObjectFieldStart(fieldName);
            gen.writeStringField(HREF, url);
            gen.writeEndObject();
        } else {
            gen.writeStringField(fieldName, url);
        }
    }

    public static String deserializeLink(String fieldName, JsonNode jsonNode) throws IOException {
        JsonNode linkNode = jsonNode.get(fieldName);
        if (linkNode != null && linkNode.has(HREF)) {
            return SerializerUtil.readStringIfExists(HREF, linkNode);
        }
        return SerializerUtil.readStringIfExists(fieldName, jsonNode);
    }

    public static String readStringIfExists(String fieldName, JsonNode jsonNode) {
        JsonNode node = jsonNode.get(fieldName);
        if (node != null) {
            return node.asText();
        }
        return null;
    }

    public static void writeStringIfExists(String fieldName, String value, JsonGenerator gen) throws IOException {
        if (value != null) {
            gen.writeStringField(fieldName, value);
        }
    }
}

