/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.DefaultQuerySpecDeserializer;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.QuerySpecSerializer;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.queryspec.internal.UrlMapperAdapter;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.legacy.queryParams.QueryParams;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class JsonApiUrlBuilder {
    private final QueryContext queryContext;
    private final ModuleRegistry moduleRegistry;

    public JsonApiUrlBuilder(ModuleRegistry moduleRegistry, QueryContext queryContext) {
        this.queryContext = queryContext;
        this.moduleRegistry = moduleRegistry;
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QueryParams queryParams) {
        return this.buildUrl(resourceInformation, id, queryParams, null);
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QuerySpec querySpec) {
        return this.buildUrl(resourceInformation, id, querySpec, null);
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QueryAdapter queryAdapter, String relationshipName) {
        return this.buildUrl(resourceInformation, id, ((QuerySpecAdapter)queryAdapter).getQuerySpec(), relationshipName);
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QuerySpec querySpec, String relationshipName) {
        return this.buildUrlInternal(resourceInformation, id, querySpec, relationshipName, true);
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QuerySpec querySpec, String relationshipName, boolean selfLink) {
        return this.buildUrlInternal(resourceInformation, id, querySpec, relationshipName, selfLink);
    }

    public String buildUrl(ResourceInformation resourceInformation, Object id, QueryParams queryParams, String relationshipName) {
        return this.buildUrlInternal(resourceInformation, id, queryParams, relationshipName, true);
    }

    private String buildUrlInternal(ResourceInformation resourceInformation, Object id, Object query, String relationshipName, boolean selfLink) {
        String url;
        ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
        if (id instanceof Collection) {
            if (resourceInformation.isNested()) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            url = resourceRegistry.getResourceUrl(this.queryContext, resourceInformation);
            Collection ids = (Collection)id;
            ArrayList<String> strIds = new ArrayList<String>();
            for (Object idElem : ids) {
                String strIdElem = resourceInformation.toIdString(idElem);
                strIds.add(strIdElem);
            }
            url = url + "/";
            url = url + StringUtils.join(",", strIds);
        } else {
            url = id != null ? resourceRegistry.getResourceUrl(this.queryContext, resourceInformation, id) : resourceRegistry.getResourceUrl(this.queryContext, resourceInformation);
        }
        if (relationshipName != null && selfLink) {
            url = url + "/relationships/" + relationshipName;
        } else if (relationshipName != null) {
            url = url + "/" + relationshipName;
        }
        UrlParameterBuilder urlBuilder = new UrlParameterBuilder(url);
        QuerySpec querySpec = (QuerySpec)query;
        QuerySpecUrlMapper urlMapper = this.moduleRegistry.getUrlMapper();
        urlBuilder.addQueryParameters(urlMapper.serialize(querySpec));
        return urlBuilder.toString();
    }

    @Deprecated
    public QuerySpecSerializer getQuerySpecSerializer() {
        return (QuerySpecSerializer)((Object)this.moduleRegistry.getUrlMapper());
    }

    @Deprecated
    public void setQuerySpecSerializer(QuerySpecSerializer querySpecSerializer) {
        UrlMapperAdapter adapter = new UrlMapperAdapter(new DefaultQuerySpecDeserializer());
        adapter.setSerializer(querySpecSerializer);
        this.moduleRegistry.setUrlMapper(adapter);
    }

    class UrlParameterBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean firstParam;
        private String encoding = "UTF-8";

        public UrlParameterBuilder(String baseUrl) {
            this.builder.append(baseUrl);
            this.firstParam = !baseUrl.contains("?");
        }

        public String toString() {
            return this.builder.toString();
        }

        private void addQueryParameters(Map<String, ?> params) {
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    this.addQueryParameter(key, value);
                }
            }
        }

        public void addQueryParameter(String key, final String value) {
            if (this.firstParam) {
                this.builder.append("?");
                this.firstParam = false;
            } else {
                this.builder.append("&");
            }
            this.builder.append(key);
            this.builder.append("=");
            ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    UrlParameterBuilder.this.builder.append(URLEncoder.encode(value, UrlParameterBuilder.this.encoding));
                    return null;
                }
            });
        }

        private void addQueryParameter(String key, Object value) {
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    this.addQueryParameter(key, (String)element);
                }
            } else {
                this.addQueryParameter(key, (String)value);
            }
        }
    }
}

