/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import java.util.concurrent.Callable;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static <T> T wrapCatchedExceptions(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T wrapCatchedExceptions(Callable<T> callable, String messageFormat, Object ... params) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            String formattedMessage = String.format(messageFormat, params);
            throw new IllegalStateException(formattedMessage, e);
        }
    }
}

