/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.repository.ResourceRepository;
import java.io.Serializable;

public class ResourceRepositoryAdapterImpl
extends ResponseRepositoryAdapter
implements ResourceRepositoryAdapter {
    private final Object resourceRepository;
    private final ResourceRepositoryInformation repositoryInformation;
    private final ResourceInformation resourceInformation;
    private boolean return404OnNull;

    public ResourceRepositoryAdapterImpl(ResourceRepositoryInformation repositoryInformation, ModuleRegistry moduleRegistry, Object resourceRepository) {
        super(moduleRegistry);
        this.resourceInformation = repositoryInformation.getResource();
        this.repositoryInformation = repositoryInformation;
        this.resourceRepository = resourceRepository;
        this.return404OnNull = Boolean.parseBoolean(moduleRegistry.getPropertiesProvider().getProperty("crnk.config.resource.response.return_404"));
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    @Override
    public Result<JsonApiResponse> findOne(Object id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Serializable id = request.getId();
                Object resource = ResourceRepositoryAdapterImpl.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).findOne(id, request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).findOne(id, request.getQueryParams());
                if (resource == null && ResourceRepositoryAdapterImpl.this.return404OnNull) {
                    throw new ResourceNotFoundException(ResourceRepositoryAdapterImpl.this.resourceInformation.getResourceType());
                }
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindId(this.moduleRegistry, this.resourceInformation, queryAdapter, (Serializable)id);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findAll(QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                if (ResourceRepositoryAdapterImpl.this.resourceRepository instanceof ResourceRepositoryV2) {
                    QuerySpec querySpec = request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation);
                    resources = ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).findAll(querySpec);
                } else {
                    resources = ((ResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).findAll(request.getQueryParams());
                }
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindAll(this.moduleRegistry, this.resourceInformation, queryAdapter);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findAll(Iterable ids, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QueryAdapter queryAdapter = request.getQueryAdapter();
                Iterable ids = request.getIds();
                Iterable resources = ResourceRepositoryAdapterImpl.this.resourceRepository instanceof ResourceRepositoryV2 ? ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).findAll(ids, request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation)) : ((ResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).findAll(ids, request.getQueryParams());
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindIds(this.moduleRegistry, this.resourceInformation, queryAdapter, ids);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> update(Object entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.PATCH);
    }

    @Override
    public Result<JsonApiResponse> create(Object entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.POST);
    }

    private Result<JsonApiResponse> save(Object entity, QueryAdapter queryAdapter, final HttpMethod method) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object entity = request.getEntity();
                Object resource = ResourceRepositoryAdapterImpl.this.resourceRepository instanceof ResourceRepositoryV2 ? (method == HttpMethod.POST ? ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).create(entity) : ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).save(entity)) : ((ResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).save(entity);
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forSave(this.moduleRegistry, method, this.resourceInformation, queryAdapter, entity);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> delete(Object id, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Serializable id = request.getId();
                if (ResourceRepositoryAdapterImpl.this.resourceRepository instanceof ResourceRepositoryV2) {
                    ((ResourceRepositoryV2)ResourceRepositoryAdapterImpl.this.resourceRepository).delete(id);
                } else {
                    ((ResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).delete(id);
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forDelete(this.moduleRegistry, this.resourceInformation, queryAdapter, (Serializable)id);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Object getResourceRepository() {
        return this.resourceRepository;
    }

    public Class<?> getResourceClass() {
        return this.resourceInformation.getResourceClass();
    }
}

