/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.BulkRelationshipRepositoryV2;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.legacy.repository.RelationshipRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationshipRepositoryAdapterImpl
extends ResponseRepositoryAdapter
implements RelationshipRepositoryAdapter {
    private final Object relationshipRepository;
    private final ResourceField field;

    public RelationshipRepositoryAdapterImpl(ResourceField field, ModuleRegistry moduleRegistry, Object relationshipRepository) {
        super(moduleRegistry);
        this.field = field;
        this.relationshipRepository = relationshipRepository;
    }

    @Override
    public Result<JsonApiResponse> setRelation(Object source, Object targetId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Serializable targetId = request.getId();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelation(source, targetId, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, Arrays.asList(targetId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> setRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).setRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.PATCH, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> addRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).addRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.POST, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> removeRelations(Object source, Collection targetIds, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Object source = request.getEntity();
                Iterable targetIds = request.getIds();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    ((RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                } else {
                    ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).removeRelations(source, targetIds, field.getUnderlyingName());
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, HttpMethod.DELETE, source, queryAdapter, targetIds, field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findOneTarget(Object sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Object resource;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    resource = querySpecRepository.findOneTarget(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resource = ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).findOneTarget(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapterImpl.this.getResponse(RelationshipRepositoryAdapterImpl.this.relationshipRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findManyTargets(Object sourceId, ResourceField field, QueryAdapter queryAdapter) {
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                Iterable resources;
                RepositoryRequestSpec request = context.getRequest();
                Serializable sourceId = request.getId();
                ResourceField field = request.getRelationshipField();
                if (RelationshipRepositoryAdapterImpl.this.relationshipRepository instanceof RelationshipRepositoryV2) {
                    RelationshipRepositoryV2 querySpecRepository = (RelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    resources = querySpecRepository.findManyTargets(sourceId, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                } else {
                    resources = ((RelationshipRepository)RelationshipRepositoryAdapterImpl.this.relationshipRepository).findManyTargets(sourceId, field.getUnderlyingName(), request.getQueryParams());
                }
                return RelationshipRepositoryAdapterImpl.this.getResponse(RelationshipRepositoryAdapterImpl.this.relationshipRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, Arrays.asList(sourceId), field);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<Map<Object, JsonApiResponse>> findBulkManyTargets(Collection sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl(){

                protected Map<Object, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    QuerySpec querySpec = request.getQuerySpec(targetResourceInformation);
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), querySpec);
                    return RelationshipRepositoryAdapterImpl.this.toResponses(targetsMap, true, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, new ArrayList(sourceIds), field);
            return new ImmediateResult<Map<Object, JsonApiResponse>>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
        }
        HashMap responseMap = new HashMap();
        for (Object sourceId : sourceIds) {
            JsonApiResponse response = this.findManyTargets(sourceId, field, queryAdapter).get();
            responseMap.put(sourceId, response);
        }
        return new ImmediateResult<Map<Object, JsonApiResponse>>(responseMap);
    }

    @Override
    public Result<Map<Object, JsonApiResponse>> findBulkOneTargets(Collection sourceIds, ResourceField field, QueryAdapter queryAdapter) {
        if (this.relationshipRepository instanceof BulkRelationshipRepositoryV2) {
            ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryBulkRequestFilterChainImpl(){

                protected Map<Object, JsonApiResponse> invoke(RepositoryFilterContext context) {
                    RepositoryRequestSpec request = context.getRequest();
                    Iterable sourceIds = request.getIds();
                    ResourceField field = request.getRelationshipField();
                    QueryAdapter queryAdapter = request.getQueryAdapter();
                    BulkRelationshipRepositoryV2 bulkRepository = (BulkRelationshipRepositoryV2)RelationshipRepositoryAdapterImpl.this.relationshipRepository;
                    ResourceInformation targetResourceInformation = RelationshipRepositoryAdapterImpl.this.moduleRegistry.getResourceRegistry().getEntry(field.getOppositeResourceType()).getResourceInformation();
                    MultivaluedMap targetsMap = bulkRepository.findTargets(sourceIds, field.getUnderlyingName(), request.getQuerySpec(targetResourceInformation));
                    return RelationshipRepositoryAdapterImpl.this.toResponses(targetsMap, false, queryAdapter, field, HttpMethod.GET);
                }
            };
            RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindTarget(this.moduleRegistry, queryAdapter, new ArrayList(sourceIds), field);
            return new ImmediateResult<Map<Object, JsonApiResponse>>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
        }
        HashMap responseMap = new HashMap();
        for (Object sourceId : sourceIds) {
            JsonApiResponse response = this.findOneTarget(sourceId, field, queryAdapter).get();
            responseMap.put(sourceId, response);
        }
        return new ImmediateResult<Map<Object, JsonApiResponse>>(responseMap);
    }

    private Map<Object, JsonApiResponse> toResponses(MultivaluedMap targetsMap, boolean isMany, QueryAdapter queryAdapter, ResourceField field, HttpMethod method) {
        HashMap<Object, JsonApiResponse> responseMap = new HashMap<Object, JsonApiResponse>();
        for (Object sourceId : targetsMap.keySet()) {
            List targets = isMany ? targetsMap.getList(sourceId) : targetsMap.getUnique(sourceId, true);
            RepositoryRequestSpecImpl requestSpec = RepositoryRequestSpecImpl.forRelation(this.moduleRegistry, method, null, queryAdapter, Collections.singleton(sourceId), field);
            JsonApiResponse response = this.getResponse(this.relationshipRepository, targets, requestSpec);
            responseMap.put(sourceId, response);
        }
        return responseMap;
    }

    @Override
    public Object getRelationshipRepository() {
        return this.relationshipRepository;
    }

    @Override
    public ResourceField getResourceField() {
        return this.field;
    }
}

