/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.internal.QuerySpecAdapter;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class ResourceRepositoryFacade
implements ResourceRepositoryV2<Object, Serializable> {
    private final ModuleRegistry moduleRegistry;
    private RegistryEntry entry;

    public ResourceRepositoryFacade(RegistryEntry entry, ModuleRegistry moduleRegistry) {
        this.entry = entry;
        this.moduleRegistry = Objects.requireNonNull(moduleRegistry);
    }

    @Override
    public Class getResourceClass() {
        return this.entry.getResourceInformation().getImplementationClass();
    }

    @Override
    public Object findOne(Serializable id, QuerySpec querySpec) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        return this.toResource(adapter.findOne(id, this.toAdapter(querySpec)));
    }

    @Override
    public ResourceList findAll(QuerySpec querySpec) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        return this.toResources(adapter.findAll(this.toAdapter(querySpec)));
    }

    @Override
    public ResourceList findAll(Iterable ids, QuerySpec querySpec) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        return this.toResources(adapter.findAll(ids, this.toAdapter(querySpec)));
    }

    @Override
    public Object save(Object resource) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        return this.toResource(adapter.update(resource, this.createEmptyAdapter()));
    }

    @Override
    public Object create(Object resource) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        return this.toResource(adapter.create(resource, this.createEmptyAdapter()));
    }

    @Override
    public void delete(Serializable id) {
        ResourceRepositoryAdapter adapter = this.entry.getResourceRepository();
        this.toResource(adapter.delete(id, this.createEmptyAdapter()));
    }

    private QueryAdapter createEmptyAdapter() {
        return this.toAdapter(new QuerySpec(this.getResourceClass()));
    }

    private QueryAdapter toAdapter(QuerySpec querySpec) {
        ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
        HttpRequestContext requestContext = this.moduleRegistry.getHttpRequestContextProvider().getRequestContext();
        QueryContext queryContext = requestContext != null ? requestContext.getQueryContext() : null;
        return new QuerySpecAdapter(querySpec, resourceRegistry, queryContext);
    }

    private ResourceList toResources(Result<JsonApiResponse> responseResult) {
        JsonApiResponse response = responseResult.get();
        Collection elements = (Collection)this.toResource(responseResult);
        DefaultResourceList result = new DefaultResourceList();
        result.addAll(elements);
        result.setMeta(response.getMetaInformation());
        result.setLinks(response.getLinksInformation());
        return result;
    }

    private Object toResource(Result<JsonApiResponse> responseResult) {
        JsonApiResponse response = responseResult.get();
        if (response.getErrors() != null && response.getErrors().iterator().hasNext()) {
            ArrayList<ErrorData> errorList = new ArrayList<ErrorData>();
            response.getErrors().forEach(it -> errorList.add((ErrorData)it));
            Optional errorCode = errorList.stream().filter(it -> it.getStatus() != null).map(it -> Integer.parseInt(it.getStatus())).collect(Collectors.maxBy(Integer::compare));
            ErrorResponse errorResponse = new ErrorResponse(errorList, (Integer)errorCode.get());
            ExceptionMapperRegistry exceptionMapperRegistry = this.moduleRegistry.getExceptionMapperRegistry();
            ExceptionMapper exceptionMapper = exceptionMapperRegistry.findMapperFor(errorResponse).get();
            return exceptionMapper.fromErrorResponse(errorResponse);
        }
        return response.getEntity();
    }
}

