/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.registry.ResourceRegistryPartEvent;
import io.crnk.core.engine.registry.ResourceRegistryPartListener;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceRegistryImpl
extends ResourceRegistryPartBase
implements ResourceRegistry {
    private ModuleRegistry moduleRegistry;
    private ConcurrentHashMap<String, ResourceInformation> baseTypeCache = new ConcurrentHashMap();
    private ResourceRegistryPart rootPart;
    private ResourceRegistryPartListener rootListener = new ResourceRegistryPartListener(){

        @Override
        public void onChanged(ResourceRegistryPartEvent event) {
            ResourceRegistryImpl.this.notifyChange();
        }
    };

    public ResourceRegistryImpl(ResourceRegistryPart rootPart, ModuleRegistry moduleRegistry) {
        this.rootPart = rootPart;
        this.moduleRegistry = moduleRegistry;
        this.moduleRegistry.setResourceRegistry(this);
        this.setRootPart(rootPart);
    }

    @Override
    public RegistryEntry addEntry(Class<?> resource, RegistryEntry registryEntry) {
        return this.addEntry(registryEntry);
    }

    protected RegistryEntry findEntry(Class<?> clazz, boolean allowNull) {
        Optional<Class<?>> resourceClazz = this.getResourceClass(clazz);
        if (allowNull && !resourceClazz.isPresent()) {
            return null;
        }
        if (!resourceClazz.isPresent()) {
            throw new RepositoryNotFoundException(clazz.getCanonicalName());
        }
        return this.rootPart.getEntry(resourceClazz.get());
    }

    @Override
    public RegistryEntry findEntry(Class<?> clazz) {
        return this.findEntry(clazz, false);
    }

    public Optional<Class<?>> getResourceClass(Class<?> resourceClass) {
        for (Class<?> currentClass = resourceClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            RegistryEntry entry = this.rootPart.getEntry(currentClass);
            if (entry == null) continue;
            return Optional.of(currentClass);
        }
        return Optional.empty();
    }

    @Override
    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    @Override
    @Deprecated
    public RegistryEntry getEntryForClass(Class<?> resourceClass) {
        return this.getEntry(resourceClass);
    }

    public Optional<Class<?>> getResourceClass(Object resource) {
        return this.getResourceClass(resource.getClass());
    }

    @Override
    public String getResourceUrl(ResourceInformation resourceInformation) {
        String url = UrlUtils.removeTrailingSlash(this.getServiceUrlProvider().getUrl());
        if (url == null) {
            return null;
        }
        if (resourceInformation.isNested()) {
            throw new UnsupportedOperationException("method not available for nested resources since id of parent needed");
        }
        String resourcePath = resourceInformation.getResourcePath();
        return url != null ? String.format("%s/%s", url, resourcePath) : null;
    }

    @Override
    public String getResourceUrl(Class<?> clazz) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        return this.getResourceUrl(registryEntry.getResourceInformation());
    }

    @Override
    public String getResourceUrl(QueryContext queryContext, ResourceInformation resourceInformation) {
        String baseUrl = queryContext != null ? queryContext.getBaseUrl() : this.getServiceUrlProvider().getUrl();
        String url = UrlUtils.removeTrailingSlash(baseUrl);
        String resourcePath = resourceInformation.getResourcePath();
        return url != null ? String.format("%s/%s", url, resourcePath) : null;
    }

    @Override
    public String getResourceUrl(Object resource) {
        return this.getResourceUrl(null, resource);
    }

    @Override
    public String getResourceUrl(Class<?> clazz, String id) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        String typeUrl = this.getResourceUrl(registryEntry.getResourceInformation());
        return typeUrl != null ? String.format("%s/%s", typeUrl, id) : null;
    }

    @Override
    public String getResourceUrl(QueryContext queryContext, Object resource) {
        Optional<Class<?>> type = this.getResourceClass(resource);
        if (!type.isPresent()) {
            throw new InvalidResourceException("Not registered resource found: " + resource);
        }
        ResourceInformation resourceInformation = this.findEntry(type.get()).getResourceInformation();
        Object id = resourceInformation.getId(resource);
        return this.getResourceUrl(queryContext, resourceInformation, id);
    }

    @Override
    public String getResourceUrl(QueryContext queryContext, ResourceInformation resourceInformation, Object id) {
        if (resourceInformation.isNested()) {
            ResourceField parentField = resourceInformation.getParentField();
            Object parentId = parentField.getIdAccessor().getValue(id);
            Object nestedId = resourceInformation.getNestedIdAccessor().getValue(id);
            PreconditionUtil.verify(parentId != null, "nested resources must have a parent, got null from " + parentField.getIdName(), new Object[0]);
            PreconditionUtil.verify(nestedId != null, "nested resources must have a non-null identifier", new Object[0]);
            RegistryEntry parentEntry = this.getEntry(parentField.getOppositeResourceType());
            ResourceInformation parentInformation = parentEntry.getResourceInformation();
            ResourceField childrenField = parentInformation.findRelationshipFieldByName(parentField.getOppositeName());
            String parentUrl = this.getResourceUrl(queryContext, parentInformation) + "/" + parentInformation.toIdString(parentId);
            return parentUrl + "/" + childrenField.getJsonName() + "/" + nestedId;
        }
        return String.format("%s/%s", this.getResourceUrl(queryContext, resourceInformation), resourceInformation.toIdString(id));
    }

    @Override
    public String getResourceUrl(QueryContext queryContext, Class<?> clazz) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        return this.getResourceUrl(queryContext, registryEntry.getResourceInformation());
    }

    @Override
    public String getResourceUrl(QueryContext queryContext, Class<?> clazz, String id) {
        RegistryEntry registryEntry = this.findEntry(clazz);
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        String typeUrl = this.getResourceUrl(queryContext, resourceInformation);
        return typeUrl != null ? String.format("%s/%s", typeUrl, id) : null;
    }

    @Override
    public ResourceInformation getBaseResourceInformation(String resourceType) {
        ResourceInformation baseInformation = this.baseTypeCache.get(resourceType);
        if (baseInformation != null) {
            return baseInformation;
        }
        RegistryEntry entry = this.getEntry(resourceType);
        baseInformation = entry.getResourceInformation();
        while (baseInformation.getSuperResourceType() != null) {
            String superResourceType = baseInformation.getSuperResourceType();
            String entryResourceType = entry.getResourceInformation().getResourceType();
            entry = this.getEntry(superResourceType);
            PreconditionUtil.verify(entry != null, "superType=%s not found for resourceType=%s", superResourceType, entryResourceType);
            baseInformation = entry.getResourceInformation();
        }
        this.baseTypeCache.put(resourceType, baseInformation);
        return baseInformation;
    }

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        return this.rootPart.addEntry(entry);
    }

    @Override
    public boolean hasEntry(Class<?> clazz) {
        return this.rootPart.hasEntry(clazz);
    }

    @Override
    public boolean hasEntry(Type type) {
        return this.rootPart.hasEntry(type);
    }

    @Override
    public boolean hasEntry(String resourceType) {
        return this.rootPart.hasEntry(resourceType);
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.rootPart.getEntry(resourceType);
    }

    @Override
    public RegistryEntry getEntry(Class<?> clazz) {
        return this.rootPart.getEntry(clazz);
    }

    @Override
    public RegistryEntry getEntry(Type type) {
        return this.rootPart.getEntry(type);
    }

    @Override
    public RegistryEntry getEntryByPath(String resourcePath) {
        return this.rootPart.getEntryByPath(resourcePath);
    }

    @Override
    public Collection<RegistryEntry> getResources() {
        return this.rootPart.getResources();
    }

    public void setRootPart(ResourceRegistryPart rootPart) {
        if (this.rootPart != null) {
            this.rootPart.removeListener(this.rootListener);
        }
        if (rootPart != null) {
            rootPart.addListener(this.rootListener);
        }
        this.rootPart = rootPart;
    }
}

