/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.registry.ResourceRepositoryFacade;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.RelationshipRepositoryNotFoundException;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryEntryImpl
implements RegistryEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryEntryImpl.class);
    private RegistryEntry parentRegistryEntry = null;
    private ModuleRegistry moduleRegistry;
    private ResourceRepositoryAdapter resourceRepositoryAdapter;
    private Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapter;
    private PagingBehavior pagingBehavior;
    private ResourceInformation resourceInformation;

    public RegistryEntryImpl(ResourceInformation resourceInformation, ResourceRepositoryAdapter resourceRepositoryAdapter, Map<ResourceField, RelationshipRepositoryAdapter> relationshipRepositoryAdapters, ModuleRegistry moduleRegistry) {
        this.resourceRepositoryAdapter = resourceRepositoryAdapter;
        this.relationshipRepositoryAdapter = relationshipRepositoryAdapters;
        this.moduleRegistry = moduleRegistry;
        this.resourceInformation = resourceInformation;
        PreconditionUtil.verify(resourceInformation != null, "resourceInformation must not be null", new Object[0]);
        PreconditionUtil.verify(moduleRegistry != null, "no moduleRegistry", new Object[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.resourceInformation.getResourceType() + ", path=" + this.resourceInformation.getResourcePath() + "]";
    }

    @Override
    public ResourceRepositoryAdapter getResourceRepository() {
        if (this.resourceRepositoryAdapter != null) {
            return this.resourceRepositoryAdapter;
        }
        return this.parentRegistryEntry.getResourceRepository();
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(String fieldName) {
        ResourceField field = this.getResourceInformation().findFieldByUnderlyingName(fieldName);
        if (field == null && this.parentRegistryEntry != null) {
            return this.parentRegistryEntry.getRelationshipRepository(fieldName);
        }
        if (field == null) {
            throw new ResourceFieldNotFoundException("name=" + fieldName);
        }
        return this.getRelationshipRepository(field);
    }

    @Override
    public RelationshipRepositoryAdapter getRelationshipRepository(ResourceField field) {
        RelationshipRepositoryAdapter adapter = this.relationshipRepositoryAdapter.get(field);
        if (adapter == null && this.parentRegistryEntry != null) {
            return this.parentRegistryEntry.getRelationshipRepository(field);
        }
        if (adapter == null) {
            throw new RelationshipRepositoryNotFoundException(this.getResourceInformation().getResourceType(), field.getUnderlyingName());
        }
        return adapter;
    }

    @Override
    public ResourceInformation getResourceInformation() {
        return this.resourceInformation;
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.resourceRepositoryAdapter != null ? this.resourceRepositoryAdapter.getRepositoryInformation() : null;
    }

    @Override
    public RegistryEntry getParentRegistryEntry() {
        if (this.parentRegistryEntry != null) {
            return this.parentRegistryEntry;
        }
        ResourceInformation resourceInformation = this.getResourceInformation();
        String superResourceType = resourceInformation.getSuperResourceType();
        if (superResourceType != null) {
            ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
            return resourceRegistry.getEntry(superResourceType);
        }
        return this.parentRegistryEntry;
    }

    @Override
    @Deprecated
    public void setParentRegistryEntry(RegistryEntry parentRegistryEntry) {
        this.parentRegistryEntry = parentRegistryEntry;
    }

    @Override
    public boolean isParent(RegistryEntry registryEntry) {
        for (RegistryEntry entry = this.getParentRegistryEntry(); entry != null; entry = entry.getParentRegistryEntry()) {
            if (!entry.equals(registryEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getResourceRepositoryFacade() {
        return new ResourceRepositoryFacade(this, this.moduleRegistry);
    }

    @Override
    public PagingBehavior getPagingBehavior() {
        if (this.pagingBehavior == null) {
            ResourceInformation resourceInformation = this.getResourceInformation();
            Class<? extends PagingSpec> pagingSpecType = resourceInformation.getPagingSpecType();
            this.pagingBehavior = this.moduleRegistry.findPagingBehavior(pagingSpecType);
        }
        return this.pagingBehavior;
    }

    @Override
    public boolean hasResourceRepository() {
        RegistryEntry parent = this.getParentRegistryEntry();
        return parent == null || !parent.getResourceInformation().getResourcePath().equals(this.getResourceInformation().getResourcePath());
    }
}

