/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.contributor.ResourceFieldContributor;
import io.crnk.core.engine.information.contributor.ResourceFieldContributorContext;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.RepositoryInformationProviderContext;
import io.crnk.core.engine.information.repository.RepositoryMethodAccess;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.internal.information.repository.RelationshipRepositoryInformationImpl;
import io.crnk.core.engine.internal.registry.RegistryEntryImpl;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.RepositoryAdapterFactory;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.engine.registry.ResponseRelationshipEntry;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.internal.DefaultRepositoryInformationProviderContext;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.foward.ForwardingDirection;
import io.crnk.core.repository.foward.ForwardingRelationshipRepository;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistryEntryBuilder
implements RegistryEntryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegistryEntryBuilder.class);
    @Deprecated
    public static boolean WARN_MISSING_RELATIONSHIP_REPOSITORIES = true;
    private final DefaultInformationBuilder informationBuilder;
    private ModuleRegistry moduleRegistry;
    private DefaultResourceRepository resourceRepository;
    private Map<String, DefaultRelationshipRepository> relationshipRepositoryMap = new HashMap<String, DefaultRelationshipRepository>();
    private InformationBuilder.Resource resource;

    public DefaultRegistryEntryBuilder(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.informationBuilder = moduleRegistry.getInformationBuilder();
    }

    @Override
    public void fromImplementation(Object repository) {
        DefaultRepositoryInformationProviderContext builderContext;
        RepositoryInformationProvider repositoryInformationBuilder = this.moduleRegistry.getRepositoryInformationBuilder();
        RepositoryInformation repositoryInformation = repositoryInformationBuilder.build(repository, (RepositoryInformationProviderContext)(builderContext = new DefaultRepositoryInformationProviderContext(this.moduleRegistry)));
        if (repositoryInformation instanceof ResourceRepositoryInformation) {
            ResourceRepositoryInformation resourceRepositoryInformation = (ResourceRepositoryInformation)repositoryInformation;
            ResourceInformation resourceInformation = resourceRepositoryInformation.getResourceInformation().get();
            this.resource().from(resourceInformation);
            this.resourceRepository().information().from(resourceRepositoryInformation);
            this.resourceRepository().instance(repository);
        }
    }

    @Override
    public RegistryEntryBuilder.ResourceRepository resourceRepository() {
        if (this.resourceRepository == null) {
            this.resourceRepository = new DefaultResourceRepository();
        }
        return this.resourceRepository;
    }

    @Override
    public InformationBuilder.Resource resource() {
        if (this.resource == null) {
            this.resource = this.informationBuilder.createResource(null, null, null);
        }
        return this.resource;
    }

    @Override
    public RegistryEntryBuilder.RelationshipRepository relationshipRepositoryForField(String fieldName) {
        DefaultRelationshipRepository repository = this.relationshipRepositoryMap.get(fieldName);
        if (repository == null) {
            repository = new DefaultRelationshipRepository(null);
            this.relationshipRepositoryMap.put(fieldName, repository);
        }
        return repository;
    }

    @Override
    public RegistryEntry build() {
        if (this.resource == null) {
            return null;
        }
        ResourceInformation resourceInformation = this.buildResource();
        ResourceRepositoryAdapter resourceRepositoryAdapter = this.buildResourceRepositoryAdapter(resourceInformation);
        Map<ResourceField, RelationshipRepositoryAdapter> relationshipEntries = this.buildRelationshipAdapters(resourceInformation);
        return new RegistryEntryImpl(resourceInformation, resourceRepositoryAdapter, relationshipEntries, this.moduleRegistry);
    }

    private void checkRelationshipNaming(ResourceInformation resourceInformation) {
        for (String relationshipName : this.relationshipRepositoryMap.keySet()) {
            if (resourceInformation.findFieldByUnderlyingName(relationshipName) != null) continue;
            throw new ResourceFieldNotFoundException("failed to find relationship field '" + relationshipName + "' to setup registered relationship repository");
        }
    }

    private Map<ResourceField, RelationshipRepositoryAdapter> buildRelationshipAdapters(ResourceInformation resourceInformation) {
        this.checkRelationshipNaming(resourceInformation);
        HashMap<ResourceField, RelationshipRepositoryAdapter> map = new HashMap<ResourceField, RelationshipRepositoryAdapter>();
        for (ResourceField relationshipField : resourceInformation.getRelationshipFields()) {
            MatchedRelationship relationshipEntry = this.findMatchedRelationship(relationshipField);
            if (relationshipEntry != null) {
                map.put(relationshipField, relationshipEntry.getAdapter());
                continue;
            }
            if (!WARN_MISSING_RELATIONSHIP_REPOSITORIES) continue;
            LOGGER.warn("no relationship repository found for " + resourceInformation.getResourceType() + "." + relationshipField.getUnderlyingName());
        }
        return map;
    }

    private Map<ResourceField, ResponseRelationshipEntry> buildRelationships(ResourceInformation resourceInformation) {
        this.checkRelationshipNaming(resourceInformation);
        HashMap<ResourceField, ResponseRelationshipEntry> map = new HashMap<ResourceField, ResponseRelationshipEntry>();
        for (ResourceField relationshipField : resourceInformation.getRelationshipFields()) {
            MatchedRelationship relationshipEntry = this.findMatchedRelationship(relationshipField);
            if (relationshipEntry != null) {
                map.put(relationshipField, relationshipEntry.getLegacyEntry());
                continue;
            }
            if (!WARN_MISSING_RELATIONSHIP_REPOSITORIES) continue;
            LOGGER.warn("no relationship repository found for " + resourceInformation.getResourceType() + "." + relationshipField.getUnderlyingName());
        }
        return map;
    }

    private MatchedRelationship findMatchedRelationship(ResourceField relationshipField) {
        MatchedRelationship match = null;
        DefaultRelationshipRepository repository = this.relationshipRepositoryMap.get(relationshipField.getUnderlyingName());
        if (repository != null) {
            RelationshipRepositoryInformation relationshipInformation = repository.information.build();
            match = new MatchedRelationship(relationshipField, relationshipInformation, repository.instance);
        }
        if (match == null) {
            match = this.findRelationshipMatch(relationshipField);
        }
        if (match == null) {
            match = this.setupImplicitRelationshipRepository(relationshipField);
        }
        return match;
    }

    private MatchedRelationship findRelationshipMatch(ResourceField relationshipField) {
        Collection<Object> repositories = this.moduleRegistry.getRepositories();
        RepositoryInformationProvider repositoryInformationBuilder = this.moduleRegistry.getRepositoryInformationBuilder();
        MatchedRelationship matchedEntry = null;
        for (Object repository : repositories) {
            RelationshipRepositoryInformation relationshipRepositoryInformation;
            RelationshipMatcher matcher;
            RepositoryInformation repositoryInformation = repositoryInformationBuilder.build(repository, (RepositoryInformationProviderContext)new DefaultRepositoryInformationProviderContext(this.moduleRegistry));
            if (!(repositoryInformation instanceof RelationshipRepositoryInformation) || !(matcher = (relationshipRepositoryInformation = (RelationshipRepositoryInformation)repositoryInformation).getMatcher()).matches(relationshipField)) continue;
            if (matchedEntry != null) {
                throw new IllegalStateException("multiple repositories for " + relationshipField + ": " + repository + ", " + matchedEntry);
            }
            matcher.matches(relationshipField);
            matchedEntry = new MatchedRelationship(relationshipField, relationshipRepositoryInformation, repository);
        }
        return matchedEntry;
    }

    private ResourceInformation buildResource() {
        ResourceInformation resourceInformation = this.resource.build();
        this.contributeFields(resourceInformation);
        return resourceInformation;
    }

    private void contributeFields(final ResourceInformation resourceInformation) {
        ArrayList<ResourceFieldContributor> contributors = new ArrayList<ResourceFieldContributor>();
        contributors.addAll(this.moduleRegistry.getResourceFieldContributors());
        for (Object repo : this.moduleRegistry.getRepositories()) {
            if (!(repo instanceof ResourceFieldContributor) || contributors.contains(repo)) continue;
            contributors.add((ResourceFieldContributor)repo);
        }
        for (ResourceFieldContributor contributor : contributors) {
            List<ResourceField> contributedFields = contributor.getResourceFields(new ResourceFieldContributorContext(){

                @Override
                public ResourceInformation getResourceInformation() {
                    return resourceInformation;
                }

                @Override
                public InformationBuilder getInformationBuilder() {
                    return new DefaultInformationBuilder(DefaultRegistryEntryBuilder.this.moduleRegistry.getTypeParser());
                }
            });
            ArrayList<ResourceField> fields = new ArrayList<ResourceField>();
            fields.addAll(resourceInformation.getFields());
            fields.addAll(contributedFields);
            resourceInformation.setFields(fields);
        }
    }

    private ResourceEntry buildResourceRepository(ResourceInformation resourceInformation) {
        this.resourceRepository.information().setResourceInformation(resourceInformation);
        ResourceRepositoryInformation repositoryInformation = this.resourceRepository.information().build();
        Object instance = this.resourceRepository.instance;
        final Object decoratedRepository = this.decorateRepository(instance);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, instance.getClass()){

            public Object buildRepository() {
                return decoratedRepository;
            }
        };
        return new DirectResponseResourceEntry(repositoryInstanceBuilder, repositoryInformation);
    }

    private MatchedRelationship setupImplicitRelationshipRepository(ResourceField relationshipField) {
        RelationshipRepositoryBehavior behavior = relationshipField.getRelationshipRepositoryBehavior();
        if (behavior == RelationshipRepositoryBehavior.DEFAULT) {
            behavior = relationshipField.hasIdField() || relationshipField.getLookupIncludeAutomatically() == LookupIncludeBehavior.NONE ? RelationshipRepositoryBehavior.FORWARD_OWNER : RelationshipRepositoryBehavior.CUSTOM;
        }
        if (behavior == RelationshipRepositoryBehavior.IMPLICIT_FROM_OWNER) {
            behavior = RelationshipRepositoryBehavior.FORWARD_OWNER;
        }
        if (behavior == RelationshipRepositoryBehavior.IMPLICIT_GET_OPPOSITE_MODIFY_OWNER) {
            behavior = RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER;
        }
        if (behavior != RelationshipRepositoryBehavior.CUSTOM) {
            ForwardingRelationshipRepository repository;
            if (behavior == RelationshipRepositoryBehavior.FORWARD_OPPOSITE || behavior == RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER) {
                PreconditionUtil.verify(relationshipField.getOppositeName() != null, "field %s must specify @JsonApiRelation.opposite to make use of opposite forwarding behavior.", relationshipField.getUnderlyingName());
            }
            ResourceInformation sourceInformation = relationshipField.getParentResourceInformation();
            ResourceFieldAccess fieldAccess = relationshipField.getAccess();
            RepositoryMethodAccess access = new RepositoryMethodAccess(fieldAccess.isPostable(), fieldAccess.isPatchable(), fieldAccess.isReadable(), fieldAccess.isPatchable());
            RelationshipMatcher matcher = new RelationshipMatcher().rule().field(relationshipField).add();
            RelationshipRepositoryInformationImpl implicitRepoInformation = new RelationshipRepositoryInformationImpl(matcher, access);
            if (behavior == RelationshipRepositoryBehavior.FORWARD_OWNER) {
                repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OWNER, ForwardingDirection.OWNER);
            } else if (behavior == RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER) {
                repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OPPOSITE, ForwardingDirection.OWNER);
            } else {
                PreconditionUtil.verifyEquals((Object)RelationshipRepositoryBehavior.FORWARD_OPPOSITE, (Object)behavior, "unknown behavior for field=%s", relationshipField);
                repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OPPOSITE, ForwardingDirection.OPPOSITE);
            }
            repository.setResourceRegistry(this.moduleRegistry.getResourceRegistry());
            repository.setHttpRequestContextProvider(this.moduleRegistry.getHttpRequestContextProvider());
            return new MatchedRelationship(relationshipField, implicitRepoInformation, repository);
        }
        return null;
    }

    public Object decorateRepository(Object repository) {
        Object decoratedRepository = repository;
        List<RepositoryDecoratorFactory> repositoryDecorators = this.moduleRegistry.getRepositoryDecoratorFactories();
        for (RepositoryDecoratorFactory repositoryDecorator : repositoryDecorators) {
            decoratedRepository = repositoryDecorator.decorateRepository(decoratedRepository);
        }
        if (decoratedRepository instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)decoratedRepository).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return decoratedRepository;
    }

    private ResourceRepositoryAdapter buildResourceRepositoryAdapter(ResourceInformation resourceInformation) {
        if (this.resourceRepository == null) {
            return null;
        }
        this.resourceRepository.information().setResourceInformation(resourceInformation);
        ResourceRepositoryInformation repositoryInformation = this.resourceRepository.information().build();
        Object instance = this.resourceRepository.instance;
        Object decoratedRepository = this.decorateRepository(instance);
        List<RepositoryAdapterFactory> adapterFactories = this.moduleRegistry.getRepositoryAdapterFactories();
        ResourceRepositoryAdapter adapter = null;
        for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
            if (!adapterFactory.accepts(decoratedRepository)) continue;
            adapter = adapterFactory.createResourceRepositoryAdapter(repositoryInformation, decoratedRepository);
            break;
        }
        if (adapter == null) {
            throw new IllegalStateException("no RepositoryAdapterFactory found for " + decoratedRepository + ", make sure it is a valid repository, e.g. by implementing ResourceRepositoryV2");
        }
        for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
            adapter = adapterFactory.decorate(adapter);
        }
        return adapter;
    }

    class MatchedRelationship {
        private final ResourceField relationshipField;
        private final RelationshipRepositoryInformation relationshipRepositoryInformation;
        private final Object relRepository;

        public MatchedRelationship(ResourceField relationshipField, RelationshipRepositoryInformation relationshipRepositoryInformation, Object relRepository) {
            this.relationshipField = relationshipField;
            this.relationshipRepositoryInformation = relationshipRepositoryInformation;
            this.relRepository = relRepository;
        }

        private ResponseRelationshipEntry getLegacyEntry() {
            final Object decoratedRepository = DefaultRegistryEntryBuilder.this.decorateRepository(this.relRepository);
            RepositoryInstanceBuilder<Object> relationshipInstanceBuilder = new RepositoryInstanceBuilder<Object>(null, this.relRepository.getClass()){

                @Override
                public Object buildRepository() {
                    return decoratedRepository;
                }
            };
            final String targetResourceType = this.relationshipField.getOppositeResourceType();
            return new DirectResponseRelationshipEntry(relationshipInstanceBuilder){

                @Override
                public String getTargetResourceType() {
                    return targetResourceType;
                }
            };
        }

        private RelationshipRepositoryAdapter getAdapter() {
            Object decoratedRepository = DefaultRegistryEntryBuilder.this.decorateRepository(this.relRepository);
            List<RepositoryAdapterFactory> adapterFactories = DefaultRegistryEntryBuilder.this.moduleRegistry.getRepositoryAdapterFactories();
            RelationshipRepositoryAdapter adapter = null;
            for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
                if (!adapterFactory.accepts(decoratedRepository)) continue;
                adapter = adapterFactory.createRelationshipRepositoryAdapter(this.relationshipField, this.relationshipRepositoryInformation, decoratedRepository);
                break;
            }
            if (adapter == null) {
                throw new IllegalStateException("no RepositoryAdapterFactory found for " + decoratedRepository + ", make sure it is a valid repository, e.g. by implementing ResourceRepositoryV2");
            }
            for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
                adapter = adapterFactory.decorate(adapter);
            }
            return adapter;
        }
    }

    class DefaultRelationshipRepository
    implements RegistryEntryBuilder.RelationshipRepository {
        private final String fieldName;
        private InformationBuilder.RelationshipRepository information;
        private Object instance;

        public DefaultRelationshipRepository(String fieldName) {
            this.fieldName = fieldName;
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createRelationshipRepository(null);
        }

        @Override
        public InformationBuilder.RelationshipRepository information() {
            return this.information;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }
    }

    class DefaultResourceRepository
    implements RegistryEntryBuilder.ResourceRepository {
        private Object instance;
        private InformationBuilder.ResourceRepository information;

        public DefaultResourceRepository() {
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createResourceRepository();
        }

        @Override
        public InformationBuilder.ResourceRepository information() {
            return this.information;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }
    }
}

