/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.resource.RawResourceFieldAccessor;
import io.crnk.core.engine.internal.information.resource.ReflectionFieldAccessor;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.PatchStrategy;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import java.lang.reflect.Type;
import java.util.Objects;

public class ResourceFieldImpl
implements ResourceField {
    private String jsonName;
    private final String underlyingName;
    private final Class<?> type;
    private final Type genericType;
    private final SerializeType serializeType;
    private final String oppositeResourceType;
    private final LookupIncludeBehavior lookupIncludeBehavior;
    private ResourceFieldType resourceFieldType;
    private final String oppositeName;
    private final RelationshipRepositoryBehavior relationshipRepositoryBehavior;
    private ResourceInformation parentResourceInformation;
    private ResourceFieldAccessor accessor;
    private final ResourceFieldAccess access;
    private String idName;
    private ResourceFieldAccessor idAccessor;
    private Class idType;
    private PatchStrategy patchStrategy;

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType) {
        this(jsonName, underlyingName, resourceFieldType, type, genericType, oppositeResourceType, null, SerializeType.LAZY, LookupIncludeBehavior.NONE, new ResourceFieldAccess(true, true, true, true, true, true), null, null, null, RelationshipRepositoryBehavior.DEFAULT, PatchStrategy.DEFAULT);
    }

    public ResourceFieldImpl(String jsonName, String underlyingName, ResourceFieldType resourceFieldType, Class<?> type, Type genericType, String oppositeResourceType, String oppositeName, SerializeType serializeType, LookupIncludeBehavior lookupIncludeBehavior, ResourceFieldAccess access, String idName, Class idType, ResourceFieldAccessor idAccessor, RelationshipRepositoryBehavior relationshipRepositoryBehavior, PatchStrategy patchStrategy) {
        this.jsonName = jsonName;
        this.underlyingName = underlyingName;
        this.resourceFieldType = resourceFieldType;
        this.serializeType = serializeType;
        this.type = type;
        this.genericType = genericType;
        this.lookupIncludeBehavior = lookupIncludeBehavior;
        this.oppositeName = oppositeName;
        this.oppositeResourceType = oppositeResourceType;
        this.access = access;
        this.idName = idName;
        this.idType = idType;
        this.idAccessor = idAccessor;
        this.relationshipRepositoryBehavior = relationshipRepositoryBehavior;
        this.patchStrategy = patchStrategy;
    }

    @Deprecated
    public void setJsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    @Deprecated
    public void setResourceFieldType(ResourceFieldType resourceFieldType) {
        this.resourceFieldType = resourceFieldType;
    }

    @Override
    public ResourceFieldType getResourceFieldType() {
        return this.resourceFieldType;
    }

    @Override
    public RelationshipRepositoryBehavior getRelationshipRepositoryBehavior() {
        return this.relationshipRepositoryBehavior;
    }

    @Override
    public LookupIncludeBehavior getLookupIncludeAutomatically() {
        return this.lookupIncludeBehavior;
    }

    @Override
    public String getOppositeName() {
        return this.oppositeName;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public String getUnderlyingName() {
        return this.underlyingName;
    }

    @Override
    public String getOppositeResourceType() {
        PreconditionUtil.verifyEquals((Object)ResourceFieldType.RELATIONSHIP, (Object)this.resourceFieldType, "field %s of %s is not an association", this.underlyingName, this.parentResourceInformation.getResourceType());
        if (this.getElementType() != Object.class) {
            PreconditionUtil.verify(this.oppositeResourceType != null, "field %s of %s does not have an opposite resource type", this.underlyingName, this.parentResourceInformation.getResourceType());
        }
        return this.oppositeResourceType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public SerializeType getSerializeType() {
        return this.serializeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldImpl that = (ResourceFieldImpl)o;
        return Objects.equals(this.jsonName, that.jsonName) && this.parentResourceInformation == that.parentResourceInformation;
    }

    public int hashCode() {
        return Objects.hash(this.jsonName, this.parentResourceInformation);
    }

    @Override
    public Class<?> getElementType() {
        return ClassUtils.getRawType(ClassUtils.getElementType(this.genericType));
    }

    @Override
    public ResourceInformation getParentResourceInformation() {
        return this.parentResourceInformation;
    }

    @Override
    public ResourceFieldAccessor getAccessor() {
        PreconditionUtil.verify(this.accessor != null, "field %s not properly initialized", this.underlyingName);
        return this.accessor;
    }

    @Override
    public boolean hasIdField() {
        this.assertRelationship();
        return this.idName != null;
    }

    @Override
    public String getIdName() {
        return this.idName;
    }

    @Override
    public Class getIdType() {
        this.assertRelationship();
        return this.idType;
    }

    @Override
    public ResourceFieldAccessor getIdAccessor() {
        this.assertRelationship();
        return this.idAccessor;
    }

    public void setIdField(String idName, Class idType, ResourceFieldAccessor idAccessor) {
        this.assertRelationship();
        this.idName = idName;
        this.idType = idType;
        this.idAccessor = idAccessor;
    }

    private void assertRelationship() {
        PreconditionUtil.assertEquals("not available for non-relationship fields", (Object)ResourceFieldType.RELATIONSHIP, (Object)this.getResourceFieldType());
    }

    public void setAccessor(ResourceFieldAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void setResourceInformation(ResourceInformation resourceInformation) {
        if (this.accessor == null && resourceInformation.getResourceClass() == Resource.class) {
            this.accessor = new RawResourceFieldAccessor(this.underlyingName, this.resourceFieldType, this.type);
        } else if (this.accessor == null) {
            this.accessor = new ReflectionFieldAccessor(resourceInformation.getResourceClass(), this.underlyingName, this.type);
        }
        if (this.idAccessor == null && this.idName != null) {
            this.idAccessor = new ReflectionFieldAccessor(resourceInformation.getResourceClass(), this.idName, this.idType);
            if (this.idType == ResourceIdentifier.class) {
                this.idAccessor = new ResourceIdentifierAccessorAdapter(this.idAccessor);
            }
        }
        this.parentResourceInformation = resourceInformation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[jsonName=").append(this.jsonName);
        if (this.parentResourceInformation != null && this.parentResourceInformation.getResourceType() != null) {
            sb.append(",resourceType=").append(this.parentResourceInformation.getResourceType());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isCollection() {
        return Iterable.class.isAssignableFrom(this.getType());
    }

    @Override
    public ResourceFieldAccess getAccess() {
        return this.access;
    }

    @Override
    public PatchStrategy getPatchStrategy() {
        return this.patchStrategy;
    }

    class ResourceIdentifierAccessorAdapter
    extends ResourceFieldAccessorWrapper {
        public ResourceIdentifierAccessorAdapter(ResourceFieldAccessor idAccessor) {
            super(idAccessor);
        }

        @Override
        public void setValue(Object resource, Object fieldValue) {
            if (fieldValue == null || fieldValue instanceof ResourceIdentifier) {
                super.setValue(resource, fieldValue);
            } else {
                super.setValue(resource, new ResourceIdentifier(fieldValue.toString(), ResourceFieldImpl.this.oppositeResourceType));
            }
        }
    }

    static class ResourceFieldAccessorWrapper
    implements ResourceFieldAccessor {
        protected final ResourceFieldAccessor wrappedAccessor;

        public ResourceFieldAccessorWrapper(ResourceFieldAccessor wrappedAccessor) {
            this.wrappedAccessor = wrappedAccessor;
        }

        @Override
        public Object getValue(Object resource) {
            return this.wrappedAccessor.getValue(resource);
        }

        @Override
        public void setValue(Object resource, Object fieldValue) {
            this.wrappedAccessor.setValue(resource, fieldValue);
        }
    }
}

