/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information.resource;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceInformationProviderBase;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.FieldOrderedComparator;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.exception.RepositoryAnnotationNotFoundException;
import io.crnk.core.exception.ResourceIdNotFoundException;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.queryspec.pagingspec.VoidPagingBehavior;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.utils.Prioritizable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultResourceInformationProvider
extends ResourceInformationProviderBase
implements Prioritizable {
    public static final int PRIORITY = 100;
    private final List<? extends PagingBehavior> pagingBehaviors;

    public DefaultResourceInformationProvider(PropertiesProvider propertiesProvider, PagingBehavior pagingBehavior, ResourceFieldInformationProvider ... resourceFieldInformationProviders) {
        this(propertiesProvider, Collections.unmodifiableList(Arrays.asList(pagingBehavior)), Arrays.asList(resourceFieldInformationProviders));
    }

    public DefaultResourceInformationProvider(PropertiesProvider propertiesProvider, List<? extends PagingBehavior> pagingBehaviors, ResourceFieldInformationProvider ... resourceFieldInformationProviders) {
        this(propertiesProvider, pagingBehaviors, Arrays.asList(resourceFieldInformationProviders));
    }

    public DefaultResourceInformationProvider(PropertiesProvider propertiesProvider, List<? extends PagingBehavior> pagingBehaviors, List<ResourceFieldInformationProvider> resourceFieldInformationProviders) {
        super(propertiesProvider, resourceFieldInformationProviders);
        this.pagingBehaviors = pagingBehaviors;
    }

    @Override
    public boolean accept(Class<?> resourceClass) {
        JsonApiResource annotation = resourceClass.getAnnotation(JsonApiResource.class);
        return annotation != null;
    }

    @Override
    public ResourceInformation build(Class<?> resourceClass) {
        return this.build(resourceClass, false);
    }

    public ResourceInformation build(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        List<ResourceField> resourceFields = this.getResourceFields(resourceClass);
        String resourceType = this.getResourceType(resourceClass, allowNonResourceBaseClass);
        String resourcePath = this.getResourcePath(resourceClass, allowNonResourceBaseClass);
        Optional<JsonPropertyOrder> propertyOrder = ClassUtils.getAnnotation(resourceClass, JsonPropertyOrder.class);
        if (propertyOrder.isPresent()) {
            JsonPropertyOrder propertyOrderAnnotation = propertyOrder.get();
            Collections.sort(resourceFields, new FieldOrderedComparator(propertyOrderAnnotation.value(), propertyOrderAnnotation.alphabetic()));
        }
        DefaultResourceInstanceBuilder instanceBuilder = new DefaultResourceInstanceBuilder(resourceClass);
        Class<?> superclass = resourceClass.getSuperclass();
        String superResourceType = superclass != Object.class && this.context.accept(superclass) ? this.context.getResourceType(superclass) : null;
        JsonApiResource annotation = ClassUtils.getAnnotation(resourceClass, JsonApiResource.class).get();
        Class<PagingSpec> pagingSpec = annotation.pagingSpec();
        Class<? extends PagingBehavior> pagingBehaviorType = annotation.pagingBehavior();
        if (pagingSpec == PagingSpec.class && pagingBehaviorType != VoidPagingBehavior.class) {
            Optional<Object> optPagingBehavior;
            if (!pagingBehaviorType.equals(VoidPagingBehavior.class)) {
                optPagingBehavior = this.pagingBehaviors.stream().filter(it -> pagingBehaviorType.isInstance(it)).findFirst();
                if (!optPagingBehavior.isPresent()) {
                    throw new IllegalStateException("no paging behavior registered for: " + pagingBehaviorType);
                }
            } else {
                optPagingBehavior = this.pagingBehaviors.stream().findFirst();
                if (!optPagingBehavior.isPresent()) {
                    throw new IllegalStateException("no paging behavior registered");
                }
            }
            pagingSpec = ((PagingBehavior)optPagingBehavior.get()).createEmptyPagingSpec().getClass();
        }
        ResourceInformation information = new ResourceInformation(this.context.getTypeParser(), resourceClass, resourceType, resourcePath, superResourceType, instanceBuilder, resourceFields, pagingSpec);
        if (!allowNonResourceBaseClass && information.getIdField() == null) {
            throw new ResourceIdNotFoundException(resourceClass.getCanonicalName());
        }
        return information;
    }

    @Override
    public String getResourceType(Class<?> resourceClass) {
        return this.getResourceType(resourceClass, false);
    }

    @Override
    public String getResourcePath(Class<?> resourceClass) {
        return this.getResourcePath(resourceClass, false);
    }

    private String getResourcePath(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        JsonApiResource jsonApiResourceClass = resourceClass.getAnnotation(JsonApiResource.class);
        String resourcePath = null;
        if (jsonApiResourceClass != null) {
            resourcePath = StringUtils.isBlank(jsonApiResourceClass.resourcePath()) ? this.getResourceType(resourceClass, allowNonResourceBaseClass) : jsonApiResourceClass.resourcePath();
        }
        return resourcePath;
    }

    private String getResourceType(Class<?> resourceClass, boolean allowNonResourceBaseClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = resourceClass.getAnnotations()) {
            if (!(annotation instanceof JsonApiResource)) continue;
            JsonApiResource apiResource = (JsonApiResource)annotation;
            return apiResource.type();
        }
        if (allowNonResourceBaseClass) {
            return null;
        }
        throw new RepositoryAnnotationNotFoundException(resourceClass.getName());
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

