/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.path.ActionPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.DocumentFilterChainImpl;
import io.crnk.core.engine.internal.http.DocumentFilterContextImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessorBase;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.result.ImmediateResultFactory;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.module.Module;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiRequestProcessor
extends JsonApiRequestProcessorBase
implements HttpRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiRequestProcessor.class);

    public JsonApiRequestProcessor(Module.ModuleContext moduleContext) {
        super(moduleContext);
    }

    public static boolean isJsonApiRequest(HttpRequestContext requestContext, boolean acceptPlainJson) {
        String contentType;
        String method = requestContext.getMethod().toUpperCase();
        boolean isPatch = method.equals(HttpMethod.PATCH.toString());
        boolean isPost = method.equals(HttpMethod.POST.toString());
        if (!(!isPatch && !isPost || (contentType = requestContext.getRequestHeader("Content-Type")) != null && contentType.startsWith("application/vnd.api+json"))) {
            LOGGER.warn("not a JSON-API request due to content type {}", (Object)contentType);
            return false;
        }
        boolean acceptsJsonApi = requestContext.accepts("application/vnd.api+json");
        boolean acceptsAny = acceptsJsonApi || requestContext.acceptsAny();
        boolean acceptsPlainJson = acceptsAny || acceptPlainJson && requestContext.accepts("application/json");
        LOGGER.debug("accepting request as JSON-API: {}", (Object)acceptPlainJson);
        return acceptsPlainJson;
    }

    @Override
    public boolean supportsAsync() {
        return true;
    }

    @Override
    public boolean accepts(HttpRequestContext context) {
        if (JsonApiRequestProcessor.isJsonApiRequest(context, this.isAcceptingPlainJson())) {
            JsonPath jsonPath = this.getJsonPath(context);
            LOGGER.debug("resource path: {}", (Object)jsonPath);
            return jsonPath != null;
        }
        return false;
    }

    @Override
    public Result<HttpResponse> processAsync(HttpRequestContext requestContext) {
        Result<HttpResponse> response = this.checkMethod(requestContext);
        if (response != null) {
            return response;
        }
        String method = requestContext.getMethod();
        ResultFactory resultFactory = this.moduleContext.getResultFactory();
        String path = requestContext.getPath();
        JsonPath jsonPath = this.getJsonPath(requestContext);
        LOGGER.debug("processing JSON API request path={}, method={}", (Object)jsonPath, (Object)method);
        Map<String, Set<String>> parameters = requestContext.getRequestParameters();
        if (jsonPath instanceof ActionPath) {
            RequestDispatcher requestDispatcher = this.moduleContext.getRequestDispatcher();
            requestDispatcher.dispatchAction(path, method, parameters);
            return null;
        }
        if (jsonPath != null) {
            Document requestDocument;
            try {
                requestDocument = this.getRequestDocument(requestContext);
            }
            catch (JsonProcessingException e) {
                return resultFactory.just(this.getErrorResponse(e));
            }
            QueryContext queryContext = requestContext.getQueryContext();
            return this.processAsync(jsonPath, method, parameters, requestDocument, queryContext).map(this::toHttpResponse);
        }
        return resultFactory.just(this.buildMethodNotAllowedResponse(method));
    }

    private Result<HttpResponse> checkMethod(HttpRequestContext requestContext) {
        boolean acceptsMethod;
        String method = requestContext.getMethod();
        boolean isPatch = method.equals(HttpMethod.PATCH.toString());
        boolean isPost = method.equals(HttpMethod.POST.toString());
        boolean isGet = method.equals(HttpMethod.GET.toString());
        boolean isDelete = method.equals(HttpMethod.DELETE.toString());
        boolean bl = acceptsMethod = isGet || isDelete || isPatch || isPost;
        if (!acceptsMethod) {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            return resultFactory.just(this.buildMethodNotAllowedResponse(method));
        }
        return null;
    }

    public Result<Response> processAsync(JsonPath jsonPath, String method, Map<String, Set<String>> parameters, Document requestDocument, QueryContext queryContext) {
        try {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            ResourceInformation resourceInformation = this.getRequestedResource(jsonPath);
            QueryAdapterBuilder queryAdapterBuilder = this.moduleContext.getModuleRegistry().getQueryAdapterBuilder();
            QueryAdapter queryAdapter = queryAdapterBuilder.build(resourceInformation, parameters, queryContext);
            if (resultFactory instanceof ImmediateResultFactory) {
                LOGGER.debug("processing synchronously");
                DocumentFilterContextImpl filterContext = new DocumentFilterContextImpl(jsonPath, queryAdapter, requestDocument, method);
                try {
                    DocumentFilterChain filterChain = this.getFilterChain(jsonPath, method);
                    Response response = filterChain.doFilter(filterContext);
                    return resultFactory.just(response);
                }
                catch (Exception e) {
                    Response response = this.toErrorResponse(e);
                    return resultFactory.just(response);
                }
            }
            LOGGER.debug("processing asynchronously");
            ControllerRegistry controllerRegistry = this.moduleContext.getModuleRegistry().getControllerRegistry();
            Controller controller = controllerRegistry.getController(jsonPath, method);
            Result<Response> responseResult = controller.handleAsync(jsonPath, queryAdapter, requestDocument);
            return responseResult.onErrorResume(this::toErrorResponse);
        }
        catch (Exception e) {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            return resultFactory.just(this.toErrorResponse(e));
        }
    }

    private Response toErrorResponse(Throwable e) {
        ExceptionMapperRegistry exceptionMapperRegistry = this.moduleContext.getExceptionMapperRegistry();
        Optional<JsonApiExceptionMapper> exceptionMapper = exceptionMapperRegistry.findMapperFor(e.getClass());
        if (!exceptionMapper.isPresent()) {
            LOGGER.error("failed to process request, unknown exception thrown", e);
            e = new InternalServerErrorException(e.getMessage());
            exceptionMapper = exceptionMapperRegistry.findMapperFor(e.getClass());
            PreconditionUtil.assertTrue("no exception mapper for InternalServerErrorException found", exceptionMapper.isPresent());
        } else {
            LOGGER.debug("dispatching exception to mapper", e);
        }
        return exceptionMapper.get().toErrorResponse(e).toResponse();
    }

    protected DocumentFilterChain getFilterChain(JsonPath jsonPath, String method) {
        ControllerRegistry controllerRegistry = this.moduleContext.getModuleRegistry().getControllerRegistry();
        Controller controller = controllerRegistry.getController(jsonPath, method);
        return new DocumentFilterChainImpl(this.moduleContext, controller);
    }
}

