/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.ResourceMappingConfig;
import io.crnk.core.engine.internal.utils.SerializerUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.SelfLinksInformation;
import io.crnk.core.resource.meta.MetaInformation;
import java.util.List;

public class ResourceMapper {
    private static final String SELF_FIELD_NAME = "self";
    private final String RELATED_FIELD_NAME = "related";
    private final ResourceFilterDirectory resourceFilterDirectory;
    private DocumentMapperUtil util;
    private boolean client;
    private ObjectMapper objectMapper;

    public ResourceMapper(DocumentMapperUtil util, boolean client, ObjectMapper objectMapper, ResourceFilterDirectory resourceFilterDirectory) {
        this.util = util;
        this.client = client;
        this.objectMapper = objectMapper;
        this.resourceFilterDirectory = resourceFilterDirectory;
    }

    public Resource toData(Object entity, QueryAdapter queryAdapter) {
        ResourceMappingConfig mappingConfig = new ResourceMappingConfig();
        return this.toData(entity, queryAdapter, mappingConfig);
    }

    public Resource toData(Object entity, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        if (entity instanceof Resource) {
            return (Resource)entity;
        }
        Class<?> dataClass = entity.getClass();
        QueryContext queryContext = queryAdapter.getQueryContext();
        ResourceInformation resourceInformation = this.util.getResourceInformation(dataClass);
        Resource resource = new Resource();
        resource.setId(this.util.getIdString(entity, resourceInformation));
        resource.setType(resourceInformation.getResourceType());
        if (mappingConfig.getSerializeLinks()) {
            this.util.setLinks(resource, this.getResourceLinks(entity, resourceInformation, queryContext), queryAdapter);
        }
        this.util.setMeta(resource, this.getResourceMeta(entity, resourceInformation));
        this.setAttributes(resource, entity, resourceInformation, queryAdapter);
        this.setRelationships(resource, entity, resourceInformation, queryAdapter, mappingConfig);
        return resource;
    }

    private MetaInformation getResourceMeta(Object entity, ResourceInformation resourceInformation) {
        if (resourceInformation.getMetaField() != null) {
            return (MetaInformation)resourceInformation.getMetaField().getAccessor().getValue(entity);
        }
        return null;
    }

    public LinksInformation getResourceLinks(Object entity, ResourceInformation resourceInformation, QueryContext queryContext) {
        SelfLinksInformation self;
        LinksInformation info = resourceInformation.getLinksField() != null ? (LinksInformation)resourceInformation.getLinksField().getAccessor().getValue(entity) : new DocumentMapperUtil.DefaultSelfRelatedLinksInformation();
        if (info instanceof SelfLinksInformation && (self = (SelfLinksInformation)info).getSelf() == null) {
            self.setSelf(this.util.getSelfUrl(queryContext, resourceInformation, entity));
        }
        return info;
    }

    protected void setAttributes(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getAttributeFields(), false);
        QueryContext queryContext = queryAdapter.getQueryContext();
        for (ResourceField field : fields) {
            if (this.isIgnored(field, queryContext) || !field.getAccess().isReadable()) continue;
            this.setAttribute(resource, field, entity);
        }
    }

    protected boolean isIgnored(ResourceField field, QueryContext queryContext) {
        return this.resourceFilterDirectory != null && this.resourceFilterDirectory.get(field, HttpMethod.GET, queryContext) != FilterBehavior.NONE;
    }

    protected void setAttribute(Resource resource, ResourceField field, Object entity) {
        Object value = field.getAccessor().getValue(entity);
        JsonNode valueNode = this.objectMapper.valueToTree(value);
        resource.getAttributes().put(field.getJsonName(), valueNode);
    }

    protected void setRelationships(Resource resource, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        List<ResourceField> fields = DocumentMapperUtil.getRequestedFields(resourceInformation, queryAdapter, resourceInformation.getRelationshipFields(), true);
        QueryContext queryContext = queryAdapter.getQueryContext();
        for (ResourceField field : fields) {
            if (this.isIgnored(field, queryContext)) continue;
            this.setRelationship(resource, field, entity, resourceInformation, queryAdapter, mappingConfig);
        }
    }

    protected void setRelationship(Resource resource, ResourceField field, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter, ResourceMappingConfig mappingConfig) {
        boolean addLinks;
        SerializerUtil serializerUtil = DocumentMapperUtil.getSerializerUtil();
        Relationship relationship = new Relationship();
        boolean bl = addLinks = mappingConfig.getSerializeLinks() && (queryAdapter == null || !queryAdapter.getCompactMode());
        if (addLinks) {
            QueryContext queryContext = queryAdapter.getQueryContext();
            ObjectNode relationshipLinks = this.objectMapper.createObjectNode();
            String selfUrl = this.util.getRelationshipLink(resourceInformation, entity, field, false, queryContext);
            serializerUtil.serializeLink(this.objectMapper, relationshipLinks, SELF_FIELD_NAME, selfUrl);
            String relatedUrl = this.util.getRelationshipLink(resourceInformation, entity, field, true, queryContext);
            serializerUtil.serializeLink(this.objectMapper, relationshipLinks, "related", relatedUrl);
            relationship.setLinks(relationshipLinks);
        }
        resource.getRelationships().put(field.getJsonName(), relationship);
    }
}

