/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupSetter;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupUtil;
import io.crnk.core.engine.internal.document.mapper.IncludePopulatedCache;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.document.mapper.ResourceMappingConfig;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.core.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeLookupSetter.class);
    private final IncludePopulatedCache populatedCache;
    private final HashSet<ResourceIdentifier> inclusions;
    private final List<Resource> dataList;
    private final QueryAdapter queryAdapter;
    private final IncludeLookupUtil util;
    private final DocumentMappingConfig mappingConfig;
    private final ResourceRegistry resourceRegistry;
    private final ResourceMapper resourceMapper;
    private Map<ResourceIdentifier, Resource> dataMap;
    private Map<ResourceIdentifier, Object> entityMap;
    private Map<ResourceIdentifier, Resource> resourceMap;

    public IncludeRequest(Object entity, Document document, ResourceRegistry resourceRegistry, DocumentMappingConfig mappingConfig, QueryAdapter queryAdapter, IncludeLookupUtil util, ResourceMapper resourceMapper) {
        this.resourceMapper = resourceMapper;
        this.resourceRegistry = resourceRegistry;
        this.mappingConfig = mappingConfig;
        this.queryAdapter = queryAdapter;
        this.util = util;
        List entityList = DocumentMapperUtil.toList(entity);
        this.dataList = DocumentMapperUtil.toList(document.getData().get());
        this.dataMap = new HashMap<ResourceIdentifier, Resource>();
        this.entityMap = new HashMap<ResourceIdentifier, Object>();
        for (int i = 0; i < this.dataList.size(); ++i) {
            Resource dataElement = this.dataList.get(i);
            ResourceIdentifier id = dataElement.toIdentifier();
            this.entityMap.put(id, entityList.get(i));
            this.dataMap.put(id, dataElement);
        }
        this.resourceMap = new HashMap<ResourceIdentifier, Resource>();
        this.resourceMap.putAll(this.dataMap);
        this.inclusions = new HashSet();
        this.populatedCache = new IncludePopulatedCache(resourceRegistry);
    }

    public synchronized boolean isInclusionRequest(List<ResourceField> fieldPath, ResourceField resourceField) {
        return this.util.isInclusionRequested(this.queryAdapter, fieldPath) || resourceField.getSerializeType() == SerializeType.EAGER;
    }

    public synchronized List<Resource> getDataList() {
        return this.dataList;
    }

    public synchronized void removeDataFromIncluded() {
        this.inclusions.removeAll(this.dataMap.keySet());
    }

    public synchronized List<Resource> getIncluded() {
        ArrayList<Resource> included = new ArrayList<Resource>();
        for (ResourceIdentifier inclusionId : this.inclusions) {
            Resource includedResource = this.resourceMap.get(inclusionId);
            PreconditionUtil.verify(includedResource != null, "resource with id=%d not found", inclusionId);
            included.add(includedResource);
        }
        Collections.sort(included);
        LOGGER.debug("Extracted included resources {}", (Object)included.toString());
        return included;
    }

    public synchronized boolean isRelationIdSerialized(List<ResourceField> resourceFieldPath) {
        ResourceField lastResourceField = resourceFieldPath.get(resourceFieldPath.size() - 1);
        Set<String> fieldsWithEnforcedIdSerialization = this.mappingConfig.getFieldsWithEnforcedIdSerialization();
        return lastResourceField.getSerializeType() != SerializeType.LAZY || resourceFieldPath.size() == 1 && fieldsWithEnforcedIdSerialization.contains(lastResourceField.getJsonName());
    }

    public synchronized Collection<Resource> filterProcessed(Collection<Resource> resourceList, ResourceField resourceField) {
        return this.populatedCache.filterProcessed(resourceList, resourceField);
    }

    public synchronized void markForInclusion(Set<Resource> resources) {
        this.inclusions.addAll(this.util.toIds(resources));
    }

    public synchronized Resource merge(Object targetEntity) {
        ResourceMappingConfig resourceMappingConfig = this.mappingConfig.getResourceMapping();
        Resource targetResource = this.resourceMapper.toData(targetEntity, this.queryAdapter, resourceMappingConfig);
        ResourceIdentifier targetId = targetResource.toIdentifier();
        if (!this.resourceMap.containsKey(targetId)) {
            this.resourceMap.put(targetId, targetResource);
        } else {
            targetResource = this.resourceMap.get(targetId);
        }
        if (!(targetEntity instanceof Resource)) {
            this.entityMap.put(targetId, targetEntity);
        }
        return targetResource;
    }

    public synchronized void setupRelationId(Resource sourceResource, ResourceField relationshipField, Object targetEntityId) {
        String relationshipName = relationshipField.getJsonName();
        Map<String, Relationship> relationships = sourceResource.getRelationships();
        Relationship relationship = relationships.get(relationshipName);
        String oppositeType = relationshipField.getOppositeResourceType();
        RegistryEntry entry = this.resourceRegistry.getEntry(oppositeType);
        PreconditionUtil.verify(entry != null, "opposite type %s not found for relationship %s", oppositeType, relationshipName);
        ResourceInformation targetResourceInformation = entry.getResourceInformation();
        if (targetEntityId instanceof Iterable) {
            ArrayList<ResourceIdentifier> targetIds = new ArrayList<ResourceIdentifier>();
            for (Object targetElementId : (Iterable)targetEntityId) {
                targetIds.add(this.util.idToResourceId(targetResourceInformation, targetElementId));
            }
            relationship.setData(Nullable.of(targetIds));
        } else {
            ResourceIdentifier targetResourceId = this.util.idToResourceId(targetResourceInformation, targetEntityId);
            relationship.setData(Nullable.of(targetResourceId));
        }
    }

    public synchronized List<Resource> setupRelation(Resource sourceResource, ResourceField relationshipField, Object targetEntity) {
        String relationshipName = relationshipField.getJsonName();
        Map<String, Relationship> relationships = sourceResource.getRelationships();
        Relationship relationship = relationships.get(relationshipName);
        if (targetEntity instanceof Iterable) {
            ArrayList<Resource> targets = new ArrayList<Resource>();
            for (Object targetElement : (Iterable)targetEntity) {
                Resource targetResource = this.merge(targetElement);
                targets.add(targetResource);
            }
            relationship.setData(Nullable.of(this.util.toIds(targets)));
            return targets;
        }
        Resource targetResource = this.merge(targetEntity);
        relationship.setData(Nullable.of(targetResource.toIdentifier()));
        return Collections.singletonList(targetResource);
    }

    public synchronized QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    public synchronized boolean containsResource(ResourceIdentifier id) {
        return this.resourceMap.containsKey(id);
    }

    public synchronized Resource getResource(ResourceIdentifier id) {
        return Objects.requireNonNull(this.resourceMap.get(id));
    }

    public synchronized Object getEntity(ResourceIdentifier id) {
        return this.entityMap.get(id);
    }
}

