/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.document.mapper;

import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.document.mapper.IncludeBehavior;
import io.crnk.core.engine.internal.document.mapper.IncludeLookupUtil;
import io.crnk.core.engine.internal.document.mapper.IncludeRelationshipLoader;
import io.crnk.core.engine.internal.document.mapper.IncludeRequest;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.exception.InternalServerErrorException;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeLookupSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeLookupSetter.class);
    private final ResourceRegistry resourceRegistry;
    private final ResultFactory resultFactory;
    private ResourceMapper resourceMapper;
    private IncludeLookupUtil util;
    private IncludeRelationshipLoader relationshipLoader;
    private boolean allowPagination = false;

    public IncludeLookupSetter(ResourceRegistry resourceRegistry, ResourceMapper resourceMapper, PropertiesProvider propertiesProvider, ResultFactory resultFactory) {
        this.resourceMapper = resourceMapper;
        this.resourceRegistry = resourceRegistry;
        this.resultFactory = resultFactory;
        this.relationshipLoader = new IncludeRelationshipLoader(resourceRegistry, resultFactory, propertiesProvider);
        IncludeBehavior includeBehavior = IncludeLookupUtil.getIncludeBehavior(propertiesProvider);
        this.util = new IncludeLookupUtil(resourceRegistry, includeBehavior);
        this.allowPagination = propertiesProvider != null && Boolean.parseBoolean(propertiesProvider.getProperty("crnk.config.include.paging.enabled"));
    }

    public Result<Document> processInclusions(Document document, Object entity, QueryAdapter queryAdapter, DocumentMappingConfig mappingConfig) {
        QueryAdapter inclusionQueryAdapter = queryAdapter;
        if (!this.allowPagination && !queryAdapter.isEmpty()) {
            inclusionQueryAdapter = queryAdapter.duplicate();
            RegistryEntry entry = this.resourceRegistry.getEntry(queryAdapter.getResourceInformation().getResourceType());
            PagingBehavior pagingBehavior = entry.getPagingBehavior();
            if (pagingBehavior != null) {
                inclusionQueryAdapter.setPagingSpec((PagingSpec)pagingBehavior.createEmptyPagingSpec());
            }
        }
        IncludeRequest request = new IncludeRequest(entity, document, this.resourceRegistry, mappingConfig, inclusionQueryAdapter, this.util, this.resourceMapper);
        ArrayList<ResourceField> stack = new ArrayList<ResourceField>();
        Result result = this.populate(request, request.getDataList(), stack);
        return result.map(it -> {
            request.removeDataFromIncluded();
            List<Resource> included = request.getIncluded();
            LOGGER.debug("adding {} inclusions", (Object)included.size());
            document.setIncluded(included);
            return document;
        });
    }

    private Result populate(IncludeRequest request, Collection<Resource> resourceList, List<ResourceField> fieldPath) {
        Result<IncludeRequest> result = this.resultFactory.just(request);
        if (!resourceList.isEmpty()) {
            this.checkNoRecursion(fieldPath);
            Set<ResourceField> relationshipFields = this.util.getRelationshipFields(resourceList);
            for (ResourceField resourceField : relationshipFields) {
                ArrayList<ResourceField> nextFieldPath = new ArrayList<ResourceField>(fieldPath);
                nextFieldPath.add(resourceField);
                result = result.merge(it -> this.populateField(request, resourceList, resourceField, nextFieldPath));
            }
        }
        return result;
    }

    private Result populateField(IncludeRequest request, Collection<Resource> resourceList, ResourceField resourceField, List<ResourceField> fieldPath) {
        Collection<Resource> unpopulatedResourceList;
        ResourceInformation resourceInformation = resourceField.getParentResourceInformation();
        boolean includeRelationship = request.isInclusionRequest(fieldPath, resourceField);
        boolean serializeRelationId = request.isRelationIdSerialized(fieldPath);
        boolean requiresRelationData = serializeRelationId || includeRelationship;
        LOGGER.debug("populating field={} included={} serializeId={} ", new Object[]{resourceField.getUnderlyingName(), includeRelationship, serializeRelationId});
        if (requiresRelationData && !(unpopulatedResourceList = request.filterProcessed(resourceList, resourceField)).isEmpty()) {
            Result<Set<Object>> populatedResult;
            List<Resource> resourcesByType = this.util.filterByType(unpopulatedResourceList, resourceInformation);
            List<Resource> resourcesWithField = this.util.filterByLoadedRelationship(resourcesByType, resourceField);
            LookupIncludeBehavior fieldLookupIncludeBehavior = resourceField.getLookupIncludeAutomatically();
            if (!includeRelationship && resourceField.hasIdField()) {
                this.fetchRelationFromEntity(request, resourcesWithField, resourceField, false, false, includeRelationship);
                populatedResult = this.resultFactory.just(Collections.emptySet());
            } else if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_ALWAYS) {
                this.fetchRelationFromEntity(request, resourcesWithField, resourceField, false, false, includeRelationship);
                populatedResult = this.relationshipLoader.lookupRelatedResource(request, resourcesWithField, resourceField);
            } else if (fieldLookupIncludeBehavior == LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL) {
                Set<Resource> extractedResources = this.fetchRelationFromEntity(request, resourcesWithField, resourceField, true, true, includeRelationship);
                List<Resource> resourcesForLookup = this.util.findResourcesWithoutRelationshipToLoad(resourcesWithField, resourceField, request);
                populatedResult = this.relationshipLoader.lookupRelatedResource(request, resourcesForLookup, resourceField).map(lookedupResources -> this.util.union((Collection<Resource>)lookedupResources, (Collection<Resource>)extractedResources));
            } else {
                populatedResult = this.resultFactory.just(this.fetchRelationFromEntity(request, resourcesWithField, resourceField, false, true, includeRelationship));
                if (!Iterable.class.isAssignableFrom(resourceField.getType())) {
                    Nullable<Object> emptyData = Nullable.nullValue();
                    for (Resource resourceWithField : resourcesWithField) {
                        Relationship relationship = resourceWithField.getRelationships().get(resourceField.getJsonName());
                        if (relationship.getData().isPresent()) continue;
                        relationship.setData(emptyData);
                    }
                }
            }
            return populatedResult.merge(populated -> {
                if (includeRelationship && !populated.isEmpty()) {
                    request.markForInclusion((Set<Resource>)populated);
                    return this.populate(request, (Collection<Resource>)populated, fieldPath);
                }
                return this.resultFactory.just(request);
            });
        }
        return this.resultFactory.just(request);
    }

    private void checkNoRecursion(List<ResourceField> fieldPath) {
        int index = fieldPath.size();
        if (index >= 42) {
            throw new IllegalStateException("42 nested inclusions reached, aborting");
        }
    }

    private Set<Resource> fetchRelationFromEntity(IncludeRequest request, List<Resource> sourceResources, ResourceField relationshipField, boolean allowLookup, boolean fetchRelatedEntity, boolean mustInclude) {
        HashSet<Resource> loadedResources = new HashSet<Resource>();
        for (Resource sourceResource : sourceResources) {
            ResourceIdentifier id = sourceResource.toIdentifier();
            Object sourceEntity = request.getEntity(id);
            if (sourceEntity == null || sourceEntity instanceof Resource) continue;
            Object relatedEntity = null;
            if (fetchRelatedEntity) {
                relatedEntity = relationshipField.getAccessor().getValue(sourceEntity);
                if (!allowLookup && Iterable.class.isAssignableFrom(relationshipField.getType()) && relatedEntity == null) {
                    throw new InternalServerErrorException(id + " relationship field collection '" + relationshipField.getJsonName() + "' can not be null. Either set the relationship as an empty " + Iterable.class.getCanonicalName() + " or use LookupIncludeBehavior.AUTOMATICALLY_ALWAYS");
                }
            }
            if (relatedEntity != null) {
                List<Resource> relatedResources = request.setupRelation(sourceResource, relationshipField, relatedEntity);
                loadedResources.addAll(relatedResources);
                continue;
            }
            if (!relationshipField.hasIdField()) continue;
            Object relatedEntityID = relationshipField.getIdAccessor().getValue(sourceEntity);
            request.setupRelationId(sourceResource, relationshipField, relatedEntityID);
            if (!fetchRelatedEntity || relatedEntityID == null || allowLookup || !mustInclude) continue;
            throw new IllegalStateException("inconsistent relationship '" + relationshipField.getUnderlyingName() + "' for " + id + ", id set to " + relatedEntityID + ", but related object is null and lookup disabled");
        }
        return loadedResources;
    }
}

