/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.path;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public abstract class JsonPath {
    public static final String ID_SEPARATOR = ",";
    public static final String ID_SEPARATOR_PATTERN = ",|%2C";
    private RegistryEntry rootEntry;
    private List<Serializable> ids;

    public JsonPath(RegistryEntry rootEntry, List<Serializable> ids) {
        this.rootEntry = rootEntry;
        this.ids = ids;
    }

    public Collection<Serializable> getIds() {
        return this.ids;
    }

    public abstract boolean isCollection();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rootEntry.getResourceInformation().getResourcePath());
        if (this.ids != null) {
            builder.append("/");
            builder.append(this.ids);
        }
        return builder.toString();
    }

    public Serializable getId() {
        PreconditionUtil.verify(this.ids.size() == 1, "single id expected, got %s", this.ids);
        return this.ids.get(0);
    }

    public RegistryEntry getRootEntry() {
        return this.rootEntry;
    }
}

