/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import java.util.List;
import java.util.Set;

public class ResourcePostController
extends ResourceUpsert {
    @Override
    protected HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.POST.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestDocument) {
        Result<JsonApiResponse> response;
        RegistryEntry endpointRegistryEntry = jsonPath.getRootEntry();
        Resource requestResource = this.getRequestBody(requestDocument, jsonPath, HttpMethod.POST);
        RegistryEntry registryEntry = this.getRegistryEntry(requestResource.getType());
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        this.verifyTypes(HttpMethod.POST, endpointRegistryEntry, registryEntry);
        ResourceRepositoryAdapter resourceRepository = endpointRegistryEntry.getResourceRepository();
        Set<String> loadedRelationshipNames = this.getLoadedRelationshipNames(requestResource);
        QueryContext queryContext = queryAdapter.getQueryContext();
        if (Resource.class.equals(resourceInformation.getImplementationClass())) {
            response = resourceRepository.create(requestResource, queryAdapter);
        } else {
            Object entity = this.newEntity(resourceInformation, requestResource);
            this.setId(requestResource, entity, resourceInformation);
            this.setAttributes(requestResource, entity, resourceInformation, queryContext);
            this.setMeta(requestResource, entity, resourceInformation);
            this.setLinks(requestResource, entity, resourceInformation);
            Result<List> zipped = this.setRelationsAsync(entity, registryEntry, requestResource, queryAdapter, false);
            response = zipped.merge(it -> resourceRepository.create(entity, queryAdapter));
        }
        DocumentMappingConfig mappingConfig = DocumentMappingConfig.create().setFieldsWithEnforcedIdSerialization(loadedRelationshipNames);
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        return response.doWork(it -> this.validateCreatedResponse(resourceInformation, (JsonApiResponse)it)).merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig)).map(this::toResponse);
    }

    private Response toResponse(Document document) {
        Response response = new Response(document, 201);
        this.logger.debug("set response {}", (Object)response);
        return response;
    }
}

