/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import java.io.Serializable;

public class FieldResourceGetController
extends ResourceIncludeField {
    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && FieldPath.class.equals(jsonPath.getClass()) && HttpMethod.GET.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestBody) {
        FieldPath fieldPath = (FieldPath)jsonPath;
        RegistryEntry registryEntry = fieldPath.getRootEntry();
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        Serializable castedResourceId = jsonPath.getId();
        ResourceField relationshipField = fieldPath.getField();
        Class<?> baseRelationshipFieldClass = relationshipField.getType();
        DocumentMappingConfig docummentMapperConfig = DocumentMappingConfig.create();
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepository(relationshipField);
        Result<JsonApiResponse> response = Iterable.class.isAssignableFrom(baseRelationshipFieldClass) ? relationshipRepositoryForClass.findManyTargets(castedResourceId, relationshipField, queryAdapter) : relationshipRepositoryForClass.findOneTarget(castedResourceId, relationshipField, queryAdapter);
        return response.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, docummentMapperConfig)).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        if (!document.getData().isPresent()) {
            document.setData(Nullable.nullValue());
        }
        return new Response(document, 200);
    }
}

