/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.information.resource.AnyResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.information.resource.ResourceValidator;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.exception.MultipleJsonApiLinksInformationException;
import io.crnk.core.exception.MultipleJsonApiMetaInformationException;
import io.crnk.core.exception.ResourceDuplicateIdException;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelationId;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceInformation {
    private final Class<?> implementationClass;
    private final Type implementationType;
    private ResourceField parentField;
    private ResourceField idField;
    private List<ResourceField> attributeFields;
    private List<ResourceField> relationshipFields;
    private ResourceField metaField;
    private ResourceField linksField;
    private final String resourceType;
    private String resourcePath;
    private ResourceInstanceBuilder<?> instanceBuilder;
    private final TypeParser parser;
    private String superResourceType;
    private Map<String, ResourceField> fieldByJsonName = new HashMap<String, ResourceField>();
    private Map<String, ResourceField> fieldByUnderlyingName = new HashMap<String, ResourceField>();
    private Map<String, ResourceFieldAccessor> fieldAccessors = new HashMap<String, ResourceFieldAccessor>();
    private List<ResourceField> fields;
    private AnyResourceFieldAccessor anyFieldAccessor;
    private ResourceValidator validator;
    private Class<? extends PagingSpec> pagingSpecType;
    private StringMapper idStringMapper = new StringMapper(){

        public String toString(Object input) {
            return input.toString();
        }

        @Override
        public Object parse(String input) {
            Class<?> idType = ResourceInformation.this.getIdField().getType();
            return ResourceInformation.this.parser.parse(input, idType);
        }
    };
    private ResourceFieldAccessor nestedIdAccessor;
    private ResourceInformation resourceInformation;

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String superResourceType, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, null, superResourceType, null, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String resourcePath, String superResourceType, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, resourcePath, superResourceType, null, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, null, superResourceType, instanceBuilder, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String resourcePath, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this.parser = parser;
        this.implementationClass = ClassUtils.getRawType(implementationType);
        this.implementationType = implementationType;
        this.resourceType = resourceType;
        this.resourcePath = resourcePath;
        this.superResourceType = superResourceType;
        this.instanceBuilder = instanceBuilder;
        this.fields = fields;
        this.pagingSpecType = pagingSpecType;
        this.initFields();
        if (this.instanceBuilder == null) {
            this.instanceBuilder = new DefaultResourceInstanceBuilder(this.implementationClass);
        }
        this.initAny();
        if (this.idField != null) {
            this.setupNesting();
        }
    }

    private void setupNesting() {
        BeanAttributeInformation parentAttribute = null;
        BeanAttributeInformation idAttribute = null;
        BeanInformation beanInformation = BeanInformation.get(this.idField.getType());
        for (String attributeName : beanInformation.getAttributeNames()) {
            BeanAttributeInformation attribute = beanInformation.getAttribute(attributeName);
            if (attribute.getAnnotation(JsonApiRelationId.class).isPresent()) {
                PreconditionUtil.verify(parentAttribute == null, "nested identifiers can only have a single @JsonApiRelationId annotated field, got multiple for %s", beanInformation.getImplementationClass());
                parentAttribute = attribute;
                continue;
            }
            if (!attribute.getAnnotation(JsonApiId.class).isPresent()) continue;
            PreconditionUtil.verify(idAttribute == null, "nested identifiers can only one attribute being annotated with @JsonApiId, got multiple for %s", beanInformation.getImplementationClass());
            idAttribute = attribute;
        }
        if (parentAttribute != null || idAttribute != null) {
            PreconditionUtil.verify(idAttribute != null, "nested identifiers must have attribute annotated with @JsonApiId, got none for %s", beanInformation.getImplementationClass());
            PreconditionUtil.verify(parentAttribute != null, "nested identifiers must have attribute annotated with @JsonApiRelationId, got none for %s", beanInformation.getImplementationClass());
            PreconditionUtil.verify(parentAttribute.getName().endsWith("Id"), "nested identifier must have @JsonApiRelationId field being named with a 'Id' suffix, got %s", parentAttribute.getName());
            String relationshipName = parentAttribute.getName().substring(0, parentAttribute.getName().length() - 2);
            this.parentField = this.findRelationshipFieldByName(relationshipName);
            final BeanAttributeInformation finalParentAttribute = parentAttribute;
            ResourceFieldAccessor parentIdAccessor = new ResourceFieldAccessor(){

                @Override
                public Object getValue(Object object) {
                    if (ResourceInformation.this.idField.getType().isInstance(object)) {
                        return finalParentAttribute.getValue(object);
                    }
                    Object id = ResourceInformation.this.getIdField().getAccessor().getValue(object);
                    return finalParentAttribute.getValue(id);
                }

                @Override
                public void setValue(Object resource, Object fieldValue) {
                    throw new UnsupportedOperationException("cannot update nested ids");
                }
            };
            PreconditionUtil.verify(this.parentField != null, "naming of relationship to parent resource and relationship identifier within resource identifier must match, not found for %s of %s", parentAttribute.getName(), this.implementationClass);
            PreconditionUtil.verify(this.parentField.getOppositeName() != null, "relationship of a nested resource pointing to its parent must have @JsonApiRelation.opposite defined, not found for '%s' of %s", parentAttribute.getName(), this.implementationClass);
            ((ResourceFieldImpl)this.parentField).setIdField(parentAttribute.getName(), parentAttribute.getImplementationClass(), parentIdAccessor);
            final BeanAttributeInformation finalIdAttribute = idAttribute;
            this.nestedIdAccessor = new ResourceFieldAccessor(){

                @Override
                public Object getValue(Object object) {
                    if (ResourceInformation.this.idField.getType().isInstance(object)) {
                        return finalIdAttribute.getValue(object);
                    }
                    Object id = ResourceInformation.this.getIdField().getAccessor().getValue(object);
                    return finalIdAttribute.getValue(id);
                }

                @Override
                public void setValue(Object resource, Object fieldValue) {
                    throw new UnsupportedOperationException("cannot update nested ids");
                }
            };
        }
    }

    @Deprecated
    public void setValidator(ResourceValidator validator) {
        this.validator = validator;
    }

    @Deprecated
    public ResourceValidator getValidator() {
        return this.validator;
    }

    @Deprecated
    public void setIdStringMapper(StringMapper idStringMapper) {
        this.idStringMapper = idStringMapper;
    }

    public StringMapper getIdStringMapper() {
        return this.idStringMapper;
    }

    public AnyResourceFieldAccessor getAnyFieldAccessor() {
        return this.anyFieldAccessor;
    }

    private void initAny() {
        Method jsonAnySetter;
        final Method jsonAnyGetter = ClassUtils.findMethodWith(this.implementationClass, JsonAnyGetter.class);
        if (ResourceInformation.absentAnySetter(jsonAnyGetter, jsonAnySetter = ClassUtils.findMethodWith(this.implementationClass, JsonAnySetter.class))) {
            throw new InvalidResourceException(String.format("A resource %s has to have both methods annotated with @JsonAnySetter and @JsonAnyGetter", this.implementationClass.getCanonicalName()));
        }
        if (jsonAnyGetter != null) {
            this.anyFieldAccessor = new AnyResourceFieldAccessor(){

                @Override
                public Object getValue(Object resource, String name) {
                    try {
                        return jsonAnyGetter.invoke(resource, name);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ResourceException(String.format("Exception while reading %s.%s due to %s", resource, name, e.getMessage()), e);
                    }
                }

                @Override
                public void setValue(Object resource, String name, Object fieldValue) {
                    try {
                        jsonAnySetter.invoke(resource, name, fieldValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ResourceException(String.format("Exception while writting %s.%s=%s due to %s", resource, name, fieldValue, e.getMessage()), e);
                    }
                }
            };
        }
    }

    private static boolean absentAnySetter(Method jsonAnyGetter, Method jsonAnySetter) {
        return jsonAnySetter == null && jsonAnyGetter != null || jsonAnySetter != null && jsonAnyGetter == null;
    }

    private void initFields() {
        if (this.fields != null) {
            List<ResourceField> idFields = ResourceFieldType.ID.filter(this.fields);
            if (idFields.size() > 1) {
                throw new ResourceDuplicateIdException(this.implementationClass.getCanonicalName());
            }
            this.idField = idFields.isEmpty() ? null : idFields.get(0);
            this.attributeFields = ResourceFieldType.ATTRIBUTE.filter(this.fields);
            this.relationshipFields = ResourceFieldType.RELATIONSHIP.filter(this.fields);
            this.metaField = ResourceInformation.getMetaField(this.implementationClass, this.fields);
            this.linksField = ResourceInformation.getLinksField(this.implementationClass, this.fields);
            for (ResourceField resourceField : this.fields) {
                resourceField.setResourceInformation(this);
                this.fieldByJsonName.put(resourceField.getJsonName(), resourceField);
                this.fieldByUnderlyingName.put(resourceField.getUnderlyingName(), resourceField);
                this.fieldAccessors.put(resourceField.getUnderlyingName(), resourceField.getAccessor());
                if (resourceField.getResourceFieldType() != ResourceFieldType.RELATIONSHIP || !resourceField.hasIdField()) continue;
                this.fieldAccessors.put(resourceField.getIdName(), resourceField.getIdAccessor());
                if (this.fieldByUnderlyingName.containsKey(resourceField.getIdName())) continue;
                this.fieldByUnderlyingName.put(resourceField.getIdName(), resourceField);
            }
        } else {
            this.relationshipFields = Collections.emptyList();
            this.attributeFields = Collections.emptyList();
            this.fieldAccessors = null;
            this.metaField = null;
            this.linksField = null;
            this.idField = null;
        }
    }

    @Deprecated
    public void setFields(List<ResourceField> fields) {
        this.fields = fields;
        this.initFields();
    }

    public ResourceFieldAccessor getAccessor(String name) {
        return this.fieldAccessors.get(name);
    }

    private static <T> ResourceField getMetaField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> metaFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.META_INFORMATION) continue;
            metaFields.add(field);
        }
        if (metaFields.isEmpty()) {
            return null;
        }
        if (metaFields.size() > 1) {
            throw new MultipleJsonApiMetaInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)metaFields.get(0);
    }

    private static <T> ResourceField getLinksField(Class<T> resourceClass, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> linksFields = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != ResourceFieldType.LINKS_INFORMATION) continue;
            linksFields.add(field);
        }
        if (linksFields.isEmpty()) {
            return null;
        }
        if (linksFields.size() > 1) {
            throw new MultipleJsonApiLinksInformationException(resourceClass.getCanonicalName());
        }
        return (ResourceField)linksFields.get(0);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourcePath() {
        if (this.resourcePath == null) {
            return this.resourceType;
        }
        return this.resourcePath;
    }

    public String getSuperResourceType() {
        return this.superResourceType;
    }

    public <T> ResourceInstanceBuilder<T> getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    public Class<?> getResourceClass() {
        return this.getImplementationClass();
    }

    public ResourceField getIdField() {
        return this.idField;
    }

    public List<ResourceField> getAttributeFields() {
        return this.attributeFields;
    }

    public List<ResourceField> getRelationshipFields() {
        return this.relationshipFields;
    }

    public ResourceField findFieldByName(String name) {
        return this.fieldByJsonName.get(name);
    }

    public ResourceField findFieldByUnderlyingName(String name) {
        return this.fieldByUnderlyingName.get(name);
    }

    public ResourceField findRelationshipFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP ? resourceField : null;
    }

    public ResourceField findAttributeFieldByName(String name) {
        ResourceField resourceField = this.fieldByJsonName.get(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.ATTRIBUTE ? resourceField : null;
    }

    public ResourceField getMetaField() {
        return this.metaField;
    }

    public ResourceField getLinksField() {
        return this.linksField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInformation that = (ResourceInformation)o;
        return Objects.equals(this.implementationClass, that.implementationClass) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourcePath, that.resourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.implementationClass, this.resourceType, this.resourcePath);
    }

    public String toIdString(Object id) {
        if (id == null) {
            return null;
        }
        return this.idStringMapper.toString(id);
    }

    public ResourceIdentifier toResourceIdentifier(Object resourceOrId) {
        if (resourceOrId == null) {
            return null;
        }
        if (resourceOrId instanceof Resource) {
            return ((Resource)resourceOrId).toIdentifier();
        }
        if (this.implementationClass.isInstance(resourceOrId)) {
            resourceOrId = this.getId(resourceOrId);
        }
        if (resourceOrId instanceof ResourceIdentifier) {
            return (ResourceIdentifier)resourceOrId;
        }
        String strId = resourceOrId instanceof String ? (String)resourceOrId : this.toIdString(resourceOrId);
        return new ResourceIdentifier(strId, this.getResourceType());
    }

    public Serializable parseIdString(String id) {
        return (Serializable)this.idStringMapper.parse(id);
    }

    public Object getId(Object resource) {
        return this.idField.getAccessor().getValue(resource);
    }

    public void setId(Object resource, Object id) {
        this.idField.getAccessor().setValue(resource, id);
    }

    public void verify(Object resource, Document requestDocument) {
        if (this.validator != null) {
            this.validator.validate(resource, requestDocument);
        }
    }

    public List<ResourceField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Class<? extends PagingSpec> getPagingSpecType() {
        return this.pagingSpecType;
    }

    public boolean isNested() {
        return this.parentField != null;
    }

    public ResourceField getParentField() {
        PreconditionUtil.verify(this.parentField != null, "not a nested resource, cannot access parent field", new Object[0]);
        return this.parentField;
    }

    public ResourceFieldAccessor getNestedIdAccessor() {
        PreconditionUtil.verify(this.parentField != null, "not a nested resource, cannot access nested id accessor", new Object[0]);
        return this.nestedIdAccessor;
    }
}

