/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.utils.PreconditionUtil;

public class ResourceFieldAccess {
    private final boolean readable;
    private final boolean postable;
    private final boolean patchable;
    private final boolean sortable;
    private final boolean filterable;
    private final boolean deletable;

    @Deprecated
    public ResourceFieldAccess(boolean postable, boolean patchable, boolean sortable, boolean filterable) {
        this(true, postable, patchable, sortable, filterable);
    }

    @Deprecated
    public ResourceFieldAccess(boolean readable, boolean postable, boolean patchable, boolean sortable, boolean filterable) {
        this(readable, postable, patchable, postable & patchable, sortable, filterable);
    }

    public ResourceFieldAccess(boolean readable, boolean postable, boolean patchable, boolean deletable, boolean sortable, boolean filterable) {
        this.readable = readable;
        this.postable = postable;
        this.deletable = deletable;
        this.patchable = patchable;
        this.sortable = sortable;
        this.filterable = filterable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isPostable() {
        return this.postable;
    }

    public boolean isPatchable() {
        return this.patchable;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public ResourceFieldAccess and(ResourceFieldAccess other) {
        boolean readable = this.isReadable() && other.isReadable();
        boolean postable = this.isPostable() && other.isPostable();
        boolean patchable = this.isPatchable() && other.isPatchable();
        boolean sortable = this.isSortable() && other.isSortable();
        boolean filterable = this.isFilterable() && other.isFilterable();
        return new ResourceFieldAccess(readable, postable, patchable, this.deletable, sortable, filterable);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.readable ? 1231 : 1237);
        result = 31 * result + (this.patchable ? 1231 : 1237);
        result = 31 * result + (this.postable ? 1231 : 1237);
        result = 31 * result + (this.sortable ? 1231 : 1237);
        result = 31 * result + (this.filterable ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceFieldAccess other = (ResourceFieldAccess)obj;
        return this.readable == other.readable && this.patchable == other.patchable && this.postable == other.postable && this.sortable == other.sortable && this.filterable == other.filterable;
    }

    public boolean allows(HttpMethod method) {
        if (method == HttpMethod.POST) {
            return this.isPostable();
        }
        if (method == HttpMethod.GET) {
            return this.isReadable();
        }
        if (method == HttpMethod.DELETE) {
            return this.isDeletable();
        }
        PreconditionUtil.assertEquals("", (Object)method, (Object)HttpMethod.PATCH);
        return this.isPatchable();
    }
}

