/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.bean;

import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanInformation {
    private final Class implementationClass;
    private Map<String, BeanAttributeInformation> attributeMap = new HashMap<String, BeanAttributeInformation>();
    private Map<String, BeanAttributeInformation> jsonAttributeMap = new HashMap<String, BeanAttributeInformation>();
    private List<String> attributeNames = new ArrayList<String>();
    private BeanInformation superType;
    private List<BeanInformation> implementedInterfaces = new ArrayList<BeanInformation>();
    private static final ConcurrentHashMap<Class, BeanInformation> cache = new ConcurrentHashMap();

    @Deprecated
    public BeanInformation(Class implementationClass) {
        this.implementationClass = implementationClass;
        List<Field> fields = ClassUtils.getClassFields(implementationClass);
        List<Method> getters = ClassUtils.getClassGetters(implementationClass);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            BeanAttributeInformation attrDesc = new BeanAttributeInformation(this, field);
            this.attributeMap.put(field.getName(), attrDesc);
            this.attributeNames.add(field.getName());
        }
        for (Method getter : getters) {
            if (Modifier.isStatic(getter.getModifiers())) continue;
            String name = ClassUtils.getGetterFieldName(getter);
            BeanAttributeInformation attrDesc = this.attributeMap.get(name);
            if (attrDesc == null) {
                attrDesc = new BeanAttributeInformation(this, getter, name);
                this.attributeMap.put(name, attrDesc);
                this.attributeNames.add(name);
                continue;
            }
            attrDesc.setGetter(getter);
        }
        Iterator<String> iterator = this.attributeNames.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            BeanAttributeInformation attributeInformation = this.attributeMap.get(name);
            Field field = attributeInformation.getField();
            Method getter = attributeInformation.getGetter();
            if (field != null && Modifier.isPublic(field.getModifiers()) || getter != null && Modifier.isPublic(getter.getModifiers())) continue;
            iterator.remove();
            this.attributeMap.remove(name);
        }
        for (BeanAttributeInformation attrDesc : this.attributeMap.values()) {
            String name = attrDesc.getName();
            Class<?> attrType = attrDesc.getImplementationClass();
            attrDesc.setSetter(ClassUtils.findSetter(implementationClass, name, attrType));
            this.jsonAttributeMap.put(attrDesc.getJsonName(), attrDesc);
        }
        if (implementationClass.getSuperclass() != null && implementationClass.getSuperclass() != Object.class) {
            this.superType = new BeanInformation(implementationClass.getSuperclass());
        }
        for (Class<?> interfaceClass : implementationClass.getInterfaces()) {
            this.implementedInterfaces.add(new BeanInformation(interfaceClass));
        }
    }

    public BeanInformation getSuperType() {
        return this.superType;
    }

    public List<BeanInformation> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public BeanAttributeInformation getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public BeanAttributeInformation getAttributeByJsonName(String jsonName) {
        return this.jsonAttributeMap.get(jsonName);
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public static BeanInformation get(Class<?> clazz) {
        return cache.computeIfAbsent(clazz, BeanInformation::new);
    }
}

