/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.bean;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.crnk.core.engine.information.bean.BeanInformation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.jodah.typetools.TypeResolver;

public class BeanAttributeInformation {
    private String name;
    private Field field;
    private Method getter;
    private Method setter;
    private BeanInformation beanInformation;
    private String jsonName;
    private Map<Class, Optional<?>> annotations = new ConcurrentHashMap();
    private Type cachedType;

    private BeanAttributeInformation(BeanInformation beanInformation, String name) {
        this.beanInformation = beanInformation;
        this.name = name;
    }

    protected BeanAttributeInformation(BeanInformation beanInformation, Field field) {
        this(beanInformation, field.getName());
        this.field = field;
    }

    protected BeanAttributeInformation(BeanInformation beanInformation, Method getter, String name) {
        this(beanInformation, name);
        this.getter = getter;
    }

    public BeanInformation getBeanInformation() {
        return this.beanInformation;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    protected void setSetter(Method setter) {
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    protected void setGetter(Method getter) {
        if (this.getter != null) {
            throw new IllegalStateException("Getter has already been set, modifications are not allwed.");
        }
        this.getter = getter;
    }

    public Class<?> getImplementationClass() {
        if (this.field != null) {
            return this.field.getType();
        }
        return this.getter.getReturnType();
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        BeanAttributeInformation superAttrDesc;
        BeanInformation superTypeDescriptor;
        if (this.annotations.containsKey(annotationClass)) {
            return this.annotations.get(annotationClass);
        }
        Optional<Object> annotation = Optional.empty();
        if (this.field != null) {
            annotation = Optional.ofNullable(this.field.getAnnotation(annotationClass));
        }
        if (this.getter != null && !annotation.isPresent()) {
            annotation = Optional.ofNullable(this.getter.getAnnotation(annotationClass));
        }
        if (!annotation.isPresent()) {
            for (BeanInformation interfaceBeanDesc : this.beanInformation.getImplementedInterfaces()) {
                BeanAttributeInformation interfaceAttrDesc;
                if (interfaceBeanDesc != null && (interfaceAttrDesc = interfaceBeanDesc.getAttribute(this.name)) != null && (annotation = interfaceAttrDesc.getAnnotation(annotationClass)).isPresent()) break;
            }
        }
        if (!annotation.isPresent() && (superTypeDescriptor = this.beanInformation.getSuperType()) != null && (superAttrDesc = superTypeDescriptor.getAttribute(this.name)) != null) {
            annotation = superAttrDesc.getAnnotation(annotationClass);
        }
        this.annotations.put(annotationClass, annotation);
        return annotation;
    }

    public boolean isReadable() {
        return this.getter != null || this.field != null;
    }

    public Object getValue(Object bean) {
        try {
            if (this.getter != null) {
                return this.getter.invoke(bean, new Object[0]);
            }
            return this.field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setValue(Object bean, Object value) {
        try {
            if (this.setter != null) {
                this.setter.invoke(bean, value);
            } else {
                this.field.set(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getJsonName() {
        if (this.jsonName == null) {
            Optional<JsonProperty> annotation = this.getAnnotation(JsonProperty.class);
            this.jsonName = annotation.isPresent() ? annotation.get().value() : this.name;
        }
        return this.jsonName.isEmpty() ? this.name : this.jsonName;
    }

    public Type getImplementationType() {
        if (this.field != null) {
            return this.field.getGenericType();
        }
        return this.getter.getGenericReturnType();
    }

    public Type getType() {
        if (this.cachedType == null) {
            this.cachedType = TypeResolver.reify((Type)this.getImplementationType(), (Class)this.beanInformation.getImplementationClass());
        }
        return this.cachedType;
    }

    public boolean isConcretion() {
        if (this.isDeclaredHere()) {
            return false;
        }
        BeanInformation superBeanInformation = this.beanInformation.getSuperType();
        Type superType = superBeanInformation.getAttribute(this.getName()).getType();
        return !superType.equals(this.getType());
    }

    private Member getMember() {
        if (this.field != null) {
            return this.field;
        }
        return this.getter;
    }

    private Class<?> getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public boolean isDeclaredHere() {
        return this.getDeclaringClass() == this.getBeanInformation().getImplementationClass();
    }
}

