/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.utils;

import java.util.NoSuchElementException;
import java.util.Objects;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T value;

    private Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T value) {
        Objects.requireNonNull(value);
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }
}

