/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class InMemoryEvaluator {
    public static boolean matches(Object object, FilterSpec filterSpec) {
        List<FilterSpec> expressions = filterSpec.getExpression();
        if (expressions == null) {
            return InMemoryEvaluator.matchesPrimitiveOperator(object, filterSpec);
        }
        if (filterSpec.getOperator() == FilterOperator.OR) {
            return InMemoryEvaluator.matchesOr(object, expressions);
        }
        if (filterSpec.getOperator() == FilterOperator.AND) {
            return InMemoryEvaluator.matchesAnd(object, expressions);
        }
        if (filterSpec.getOperator() == FilterOperator.NOT) {
            return !InMemoryEvaluator.matches(object, FilterSpec.and(expressions));
        }
        throw new UnsupportedOperationException("not implemented " + filterSpec);
    }

    private static boolean matchesPrimitiveOperator(Object object, FilterSpec filterSpec) {
        Object value = PropertyUtils.getProperty(object, filterSpec.getAttributePath());
        FilterOperator operator = filterSpec.getOperator();
        Object filterValue = filterSpec.getValue();
        if (value instanceof Collection) {
            return InMemoryEvaluator.matchesAny((Collection)value, operator, filterValue);
        }
        return operator.matches(value, filterValue);
    }

    private static boolean matchesAny(Collection<?> col, FilterOperator operator, Object filterValue) {
        for (Object elem : col) {
            boolean matches = operator.matches(elem, filterValue);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesOr(Object object, List<FilterSpec> expressions) {
        for (FilterSpec expr : expressions) {
            if (!InMemoryEvaluator.matches(object, expr)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesAnd(Object object, List<FilterSpec> expressions) {
        for (FilterSpec expr : expressions) {
            if (InMemoryEvaluator.matches(object, expr)) continue;
            return false;
        }
        return true;
    }

    public <T> void eval(Iterable<T> resources, QuerySpec querySpec, ResourceList<T> resultList) {
        Iterator<T> iterator = resources.iterator();
        while (iterator.hasNext()) {
            resultList.add(iterator.next());
        }
        if (!querySpec.getFilters().isEmpty()) {
            FilterSpec filterSpec = FilterSpec.and(querySpec.getFilters());
            this.applyFilter(resultList, filterSpec);
        }
        long totalCount = resultList.size();
        this.applySorting(resultList, querySpec.getSort());
        this.applyPaging(resultList, querySpec);
        if (querySpec.getLimit() != null || querySpec.getOffset() != 0L) {
            MetaInformation pagedMeta;
            MetaInformation meta = resultList.getMeta();
            if (meta instanceof PagedMetaInformation) {
                pagedMeta = (PagedMetaInformation)meta;
                pagedMeta.setTotalResourceCount(totalCount);
            }
            if (meta instanceof HasMoreResourcesMetaInformation) {
                pagedMeta = (HasMoreResourcesMetaInformation)meta;
                pagedMeta.setHasMoreResources(totalCount > querySpec.getOffset() + querySpec.getLimit());
            }
        }
    }

    private <T> void applySorting(List<T> results, List<SortSpec> sortSpec) {
        if (!sortSpec.isEmpty()) {
            Collections.sort(results, new SortSpecComparator(sortSpec));
        }
    }

    private <T> void applyPaging(List<T> results, QuerySpec querySpec) {
        int offset = (int)Math.min(querySpec.getOffset(), Integer.MAX_VALUE);
        int limit = (int)Math.min(Integer.MAX_VALUE, querySpec.getLimit() != null ? querySpec.getLimit() : Integer.MAX_VALUE);
        limit = Math.min(results.size() - offset, limit);
        if (offset > 0 || limit < results.size()) {
            ArrayList<T> subList = new ArrayList<T>(results.subList(offset, offset + limit));
            results.clear();
            results.addAll(subList);
        }
    }

    private <T> void applyFilter(List<T> results, FilterSpec filterSpec) {
        if (filterSpec != null) {
            Iterator<T> iterator = results.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (InMemoryEvaluator.matches(next, filterSpec)) continue;
                iterator.remove();
            }
        }
    }

    static class SortSpecComparator<T>
    implements Comparator<T> {
        private List<SortSpec> sortSpecs;

        public SortSpecComparator(List<SortSpec> sortSpecs) {
            this.sortSpecs = sortSpecs;
        }

        @Override
        public int compare(T o1, T o2) {
            for (SortSpec orderSpec : this.sortSpecs) {
                Comparable value1 = (Comparable)PropertyUtils.getProperty(o1, orderSpec.getAttributePath());
                Comparable value2 = (Comparable)PropertyUtils.getProperty(o2, orderSpec.getAttributePath());
                int d = this.compare(value1, value2);
                if (orderSpec.getDirection() == Direction.DESC) {
                    d = -d;
                }
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        @Override
        private int compare(Comparable<Object> value1, Comparable<Object> value2) {
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            return value1.compareTo(value2);
        }
    }
}

