/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PropertyException;
import io.crnk.core.exception.RepositoryMethodException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PropertyUtils {
    private static final PropertyUtils INSTANCE = new PropertyUtils();

    private PropertyUtils() {
    }

    public static Object getProperty(Object bean, String field) {
        INSTANCE.checkParameters(bean, field);
        try {
            return INSTANCE.getPropertyValue(bean, field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw PropertyUtils.handleReflectionException(bean.getClass(), field, e);
        }
    }

    public static Class<?> getPropertyClass(Class<?> beanClass, String field) {
        return INSTANCE.findPropertyClass(beanClass, field);
    }

    public static Type getPropertyType(Class<?> beanClass, String field) {
        return INSTANCE.findPropertyType(beanClass, field);
    }

    public static Object getProperty(Object bean, List<String> propertyPath) {
        ArrayList<Object> current = bean;
        for (String propertyName : propertyPath) {
            if (current == null) {
                return null;
            }
            if (current instanceof Iterable) {
                ArrayList<Object> result = new ArrayList<Object>();
                Iterable iterable = current;
                for (Object currentElem : iterable) {
                    result.add(PropertyUtils.getProperty(currentElem, propertyName));
                }
                current = result;
                continue;
            }
            current = PropertyUtils.getProperty((Object)current, propertyName);
        }
        return current;
    }

    public static Class<?> getPropertyClass(Class<?> clazz, List<String> propertyPath) {
        Class<?> current = clazz;
        for (String propertyName : propertyPath) {
            current = PropertyUtils.getPropertyClass(current, propertyName);
        }
        return current;
    }

    public static void setProperty(Object bean, String field, Object value) {
        INSTANCE.checkParameters(bean, field);
        try {
            INSTANCE.setPropertyValue(bean, field, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw PropertyUtils.handleReflectionException(bean.getClass(), field, e);
        }
    }

    private static RuntimeException handleReflectionException(Class<?> beanClass, String field, ReflectiveOperationException e) {
        if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof RuntimeException) {
            return (RuntimeException)((InvocationTargetException)e).getTargetException();
        }
        return new PropertyException(e, beanClass, field);
    }

    public static Object prepareValue(Object value, Class<?> fieldClass) {
        if (Set.class.isAssignableFrom(fieldClass) && value instanceof List) {
            return new LinkedHashSet((List)value);
        }
        if (List.class.isAssignableFrom(fieldClass) && value instanceof Set) {
            return new LinkedList((Set)value);
        }
        return value;
    }

    private void checkParameters(Object bean, String field) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("No field specified for bean: %s", bean.getClass()));
        }
    }

    private Object getPropertyValue(Object bean, String fieldName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Field foundField = this.findField(bean.getClass(), fieldName);
        if (foundField != null) {
            if (!Modifier.isPublic(foundField.getModifiers())) {
                Method getter = this.getGetter(bean.getClass(), foundField.getName());
                return getter.invoke(bean, new Object[0]);
            }
            return foundField.get(bean);
        }
        Method getter = this.findGetter(bean.getClass(), fieldName);
        this.checkGetterNotNull(getter, bean.getClass(), fieldName);
        return getter.invoke(bean, new Object[0]);
    }

    private void checkGetterNotNull(Method getter, Class<?> beanClass, String fieldName) {
        if (getter == null) {
            String message = String.format("Cannot find an getter for %s.%s", beanClass.getCanonicalName(), fieldName);
            throw new PropertyException(message, beanClass, fieldName);
        }
    }

    private Class<?> findPropertyClass(Class<?> beanClass, String fieldName) {
        Field foundField = this.findField(beanClass, fieldName);
        if (foundField != null) {
            return foundField.getType();
        }
        Method getter = this.findGetter(beanClass, fieldName);
        this.checkGetterNotNull(getter, beanClass, fieldName);
        return getter.getReturnType();
    }

    private Type findPropertyType(Class<?> beanClass, String fieldName) {
        Field foundField = this.findField(beanClass, fieldName);
        if (foundField != null) {
            return foundField.getGenericType();
        }
        Method getter = this.findGetter(beanClass, fieldName);
        this.checkGetterNotNull(getter, beanClass, fieldName);
        return getter.getGenericReturnType();
    }

    private Method findGetter(Class<?> beanClass, String fieldName) {
        List<Method> classGetters = ClassUtils.getClassGetters(beanClass);
        for (Method getter : classGetters) {
            String getterFieldName = ClassUtils.getGetterFieldName(getter);
            if (!getterFieldName.equals(fieldName)) continue;
            return getter;
        }
        return null;
    }

    private Field findField(Class<?> beanClass, String fieldName) {
        List<Field> classFields = ClassUtils.getClassFields(beanClass);
        for (Field field : classFields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private Method getGetter(Class<?> beanClass, String fieldName) throws NoSuchMethodException {
        Method getter = ClassUtils.findGetter(beanClass, fieldName);
        if (getter != null) {
            return getter;
        }
        throw new RepositoryMethodException(String.format("Unable to find accessor method for %s.%s", beanClass.getName(), fieldName));
    }

    private void setPropertyValue(Object bean, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Field foundField = this.findField(bean.getClass(), fieldName);
        if (foundField != null) {
            if (!Modifier.isPublic(foundField.getModifiers())) {
                Method setter = this.getSetter(bean, foundField.getName(), foundField.getType());
                setter.invoke(bean, PropertyUtils.prepareValue(value, setter.getParameterTypes()[0]));
            } else {
                foundField.set(bean, PropertyUtils.prepareValue(value, foundField.getType()));
            }
        } else {
            Method getter = this.findGetter(bean.getClass(), fieldName);
            this.checkGetterNotNull(getter, bean.getClass(), fieldName);
            String getterFieldName = ClassUtils.getGetterFieldName(getter);
            Method setter = this.getSetter(bean, getterFieldName, getter.getReturnType());
            setter.invoke(bean, PropertyUtils.prepareValue(value, setter.getParameterTypes()[0]));
        }
    }

    private Method getSetter(Object bean, String fieldName, Class<?> fieldType) throws NoSuchMethodException {
        Class<?> beanClass = bean.getClass();
        Method setter = ClassUtils.findSetter(beanClass, fieldName, fieldType);
        if (setter != null) {
            return setter;
        }
        throw new RepositoryMethodException(String.format("Unable to find accessor method for %s.%s", beanClass.getName(), fieldName));
    }
}

