/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.subscriber;

import io.continual.onap.services.mrCommon.Clock;
import io.continual.onap.services.mrCommon.CommonClientBuilder;
import io.continual.onap.services.mrCommon.HostSelector;
import io.continual.onap.services.mrCommon.HttpHelper;
import io.continual.onap.services.mrCommon.JsonResponseParser;
import io.continual.onap.services.mrCommon.SimpleJsonResponseParser;
import io.continual.onap.services.subscriber.OnapMrFetchResponse;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;

public class OnapMsgRouterSubscriber {
    private final HostSelector fHosts;
    private final String fTopic;
    private final String fSubGroup;
    private final String fSubId;
    private final long fServerWaitMs;
    private final int fMaxEventsPerFetch;
    private final long fTrxWaitTimeoutMs;
    private final boolean fDefaultHttps;
    private final HttpHelper.Credentials fCreds;
    private final String fLabel;
    private final Clock fClock;
    private final OkHttpClient fHttpClient;
    private final JsonResponseParser fResponseParser;
    private final Logger fLog;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.fLabel;
    }

    public OnapMrFetchResponse fetch() {
        return this.fetch(-1L, -1);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OnapMrFetchResponse fetch(long waitAtServerMs, int maxEventsToFetch) {
        if (waitAtServerMs < 0L) {
            waitAtServerMs = this.fServerWaitMs;
        }
        if (maxEventsToFetch < 0) {
            maxEventsToFetch = this.fMaxEventsPerFetch;
        }
        ArrayList<String> hostsLeft = new ArrayList<String>();
        this.fHosts.copyInto(hostsLeft);
        long noResponseTimeoutMs = this.fClock.nowMs() + this.fTrxWaitTimeoutMs;
        while (this.fClock.nowMs() < noResponseTimeoutMs && !hostsLeft.isEmpty()) {
            long trxDurationMs;
            long trxEndMs;
            String host = hostsLeft.remove(0);
            String path = this.buildPath(host, waitAtServerMs, maxEventsToFetch);
            Request.Builder reqBuilder = new Request.Builder().url(path).get();
            HttpHelper.addAuth(reqBuilder, this.fCreds, this.fClock);
            Request req = reqBuilder.build();
            this.fLog.info("GET {} ({})", (Object)path, (Object)this.fCreds.getUserDescription());
            long trxStartMs = this.fClock.nowMs();
            try {
                Response response = this.fHttpClient.newCall(req).execute();
                try {
                    trxEndMs = this.fClock.nowMs();
                    trxDurationMs = trxEndMs - trxStartMs;
                    int statusCode = response.code();
                    String statusText = response.message();
                    this.fLog.info("    Cambria reply {} {} ({} ms)", new Object[]{statusCode, statusText, trxDurationMs});
                    if (HttpHelper.isSuccess(statusCode)) {
                        OnapMrFetchResponse fetchResponse = new OnapMrFetchResponse(statusCode, statusText);
                        ResponseBody body = response.body();
                        if (body != null) {
                            this.fResponseParser.parseResponseBody(body, fetchResponse);
                        }
                        OnapMrFetchResponse onapMrFetchResponse = fetchResponse;
                        return onapMrFetchResponse;
                    }
                    if (HttpHelper.isClientFailure(statusCode)) {
                        OnapMrFetchResponse onapMrFetchResponse = new OnapMrFetchResponse(statusCode, statusText, new LinkedList<String>());
                        return onapMrFetchResponse;
                    }
                    if (!HttpHelper.isServerFailure(statusCode)) continue;
                    this.fHosts.demote(host);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (IOException x) {
                trxEndMs = this.fClock.nowMs();
                trxDurationMs = trxEndMs - trxStartMs;
                this.fLog.warn("    Cambria failure for host [{}]: {} ({} ms)", new Object[]{host, x.getMessage(), trxDurationMs});
                this.fHosts.demote(host);
            }
            catch (Throwable t) {
                this.fLog.warn("    Throwable {}", (Object)t.getMessage(), (Object)t);
                throw t;
            }
        }
        return new OnapMrFetchResponse(503, "No Cambria  server could acknowledge the request.", new LinkedList<String>());
    }

    private String buildPath(String host, long waitAtServerMs, int maxEventsToFetch) {
        StringBuilder sb = new StringBuilder();
        if (!host.contains("://")) {
            sb.append(this.fDefaultHttps ? "https://" : "http://");
        }
        sb.append(host);
        if (!host.contains(":")) {
            sb.append(host.startsWith("https://") ? ":3905" : ":3904");
        }
        sb.append("/events/").append(HttpHelper.urlEncode(this.fTopic)).append("/").append(HttpHelper.urlEncode(this.fSubGroup)).append("/").append(HttpHelper.urlEncode(this.fSubId));
        boolean argsAdded = false;
        if (waitAtServerMs > -1L) {
            sb.append("?timeout=").append(waitAtServerMs);
            argsAdded = true;
        }
        if ((long)maxEventsToFetch > -1L) {
            sb.append(argsAdded ? "&" : "?").append("limit=").append(maxEventsToFetch);
            argsAdded = true;
        }
        return sb.toString();
    }

    Clock getClock() {
        return this.fClock;
    }

    private OnapMsgRouterSubscriber(Builder builder) {
        if (builder.getHosts().isEmpty()) {
            throw new IllegalArgumentException("No hosts provided.");
        }
        this.fHosts = HostSelector.builder().withHosts(builder.getHosts()).build();
        this.fDefaultHttps = builder.getDefaultHttps();
        this.fCreds = builder.getCredentials();
        if (this.fCreds == null) {
            throw new IllegalArgumentException("No credentials instance provided.");
        }
        this.fTopic = builder.getTopic();
        if (this.fTopic == null || this.fTopic.length() < 1) {
            throw new IllegalArgumentException("No topic provided.");
        }
        this.fSubGroup = builder.fSubGroup;
        if (this.fSubGroup == null || this.fSubGroup.length() < 1) {
            throw new IllegalArgumentException("No subscription group provided.");
        }
        this.fSubId = builder.fSubId == null ? UUID.randomUUID().toString() : builder.fSubId;
        this.fServerWaitMs = builder.fServerWaitMs;
        this.fMaxEventsPerFetch = builder.fMaxEventsPerFetch;
        this.fTrxWaitTimeoutMs = builder.getTransactionWaitMs();
        this.fLog = builder.getLog();
        if (this.fLog == null) {
            throw new IllegalArgumentException("You must provide a logger.");
        }
        this.fClock = builder.getClock();
        long socketTimeoutMs = builder.getSocketWaitMs();
        OkHttpClient.Builder okb = new OkHttpClient.Builder().connectTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS).readTimeout(socketTimeoutMs, TimeUnit.MILLISECONDS);
        Proxy proxy = builder.getProxy();
        if (proxy != null) {
            okb = okb.proxy(proxy);
        }
        this.fHttpClient = okb.build();
        this.fResponseParser = builder.fResponseParser;
        if (this.fResponseParser == null) {
            throw new IllegalArgumentException("A response parser is required.");
        }
        this.fLabel = this.fTopic + " on " + this.fHosts.toString() + " as " + this.fCreds.getUserDescription();
    }

    public static class Builder
    extends CommonClientBuilder {
        public static final int NO_RECV_LIMIT = -1;
        private String fSubGroup = null;
        private String fSubId = null;
        private long fServerWaitMs = 15000L;
        private int fMaxEventsPerFetch = -1;
        private JsonResponseParser fResponseParser = new SimpleJsonResponseParser();

        @Override
        public Builder withHost(String host) {
            super.withHost(host);
            return this;
        }

        @Override
        public Builder withHosts(Collection<String> hosts) {
            super.withHosts(hosts);
            return this;
        }

        @Override
        public Builder withHosts(String[] hosts) {
            super.withHosts(hosts);
            return this;
        }

        @Override
        public Builder forgetHosts() {
            super.forgetHosts();
            return this;
        }

        @Override
        public Builder onTopic(String topic) {
            super.onTopic(topic);
            return this;
        }

        public Builder inGroup(String group) {
            this.fSubGroup = group;
            return this;
        }

        public Builder withSubscriberId(String id) {
            this.fSubId = id;
            return this;
        }

        public Builder waitAtServerAtMost(long ms) {
            this.fServerWaitMs = ms;
            return this;
        }

        public Builder recvAtMostEvents(int eventCount) {
            this.fMaxEventsPerFetch = eventCount;
            return this;
        }

        @Override
        public Builder logTo(Logger log) {
            super.logTo(log);
            return this;
        }

        public Builder noRecvLimit() {
            return this.recvAtMostEvents(-1);
        }

        @Override
        public Builder transactionTimeAtMost(long ms) {
            super.transactionTimeAtMost(ms);
            return this;
        }

        @Override
        public Builder socketWaitAtMost(long ms) {
            super.socketWaitAtMost(ms);
            return this;
        }

        @Override
        public Builder asUser(String user, String pwd) {
            super.asUser(user, pwd);
            return this;
        }

        @Override
        public Builder withApiKey(String apiKey, String apiSecret) {
            super.withApiKey(apiKey, apiSecret);
            return this;
        }

        @Override
        public Builder defaultHttp() {
            return this.defaultHttps(false);
        }

        @Override
        public Builder defaultHttps() {
            return this.defaultHttps(true);
        }

        @Override
        public Builder defaultHttps(boolean https) {
            super.defaultHttps(https);
            return this;
        }

        @Override
        public Builder withClock(Clock clock) {
            super.withClock(clock);
            return this;
        }

        @Override
        public Builder usingProxy(String proxy) {
            super.usingProxy(proxy);
            return this;
        }

        @Override
        public Builder usingProxy(String host, int port) {
            super.usingProxy(host, port);
            return this;
        }

        public Builder parseWith(JsonResponseParser p) {
            this.fResponseParser = p;
            return this;
        }

        public OnapMsgRouterSubscriber build() {
            return new OnapMsgRouterSubscriber(this);
        }
    }
}

