/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.security;

import com.google.common.collect.ImmutableMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ICredential {
    public static Anonymous anonymous() {
        return Anonymous.INSTANCE;
    }

    public boolean isAnonymous();

    public String getApiKeyId();

    public ImmutableMap<String, String> getProperties();

    public String sign(String var1);

    @Immutable
    public static final class Anonymous
    implements ICredential {
        private static final Anonymous INSTANCE = new Anonymous();

        @Override
        public boolean isAnonymous() {
            return true;
        }

        @Override
        public String getApiKeyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableMap<String, String> getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sign(String payload) {
            throw new UnsupportedOperationException();
        }

        private Anonymous() {
        }
    }
}

