/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.websocket;

import io.contek.invoker.commons.api.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.api.websocket.ConsumerState;
import io.contek.invoker.commons.api.websocket.IWebSocketComponent;
import io.contek.invoker.commons.api.websocket.IWebSocketListener;
import io.contek.invoker.commons.api.websocket.WebSocketSession;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class WebSocketComponentManager {
    private final List<IWebSocketComponent> active = new LinkedList<IWebSocketComponent>();
    private final List<IWebSocketComponent> idle = new LinkedList<IWebSocketComponent>();

    WebSocketComponentManager() {
    }

    void attach(IWebSocketComponent component) {
        switch (component.getState()) {
            case ACTIVE: {
                this.active.add(component);
                break;
            }
            case IDLE: {
                this.idle.add(component);
                break;
            }
            default: {
                throw new IllegalStateException(component.getState().name());
            }
        }
    }

    void refresh() {
        Iterator<IWebSocketComponent> idleIt = this.idle.iterator();
        while (idleIt.hasNext()) {
            IWebSocketComponent next = idleIt.next();
            switch (next.getState()) {
                case ACTIVE: {
                    this.active.add(next);
                }
                case TERMINATED: {
                    idleIt.remove();
                }
            }
        }
        Iterator<IWebSocketComponent> activeIt = this.active.iterator();
        while (activeIt.hasNext()) {
            IWebSocketComponent next = activeIt.next();
            switch (next.getState()) {
                case IDLE: {
                    this.idle.add(next);
                }
                case TERMINATED: {
                    activeIt.remove();
                }
            }
        }
    }

    void heartbeat(WebSocketSession session) {
        this.active.forEach(c -> c.heartbeat(session));
    }

    boolean hasActiveComponent() {
        return !this.active.isEmpty();
    }

    boolean hasComponent() {
        return !this.active.isEmpty() || !this.idle.isEmpty();
    }

    void onMessage(AnyWebSocketMessage message) {
        this.active.forEach(component -> component.onMessage(message));
    }

    void afterDisconnect() {
        this.active.forEach(IWebSocketListener::afterDisconnect);
        this.active.removeIf(component -> component.getState() == ConsumerState.TERMINATED);
        this.idle.forEach(IWebSocketListener::afterDisconnect);
        this.idle.removeIf(component -> component.getState() == ConsumerState.TERMINATED);
    }
}

