/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.rest;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class RestParams {
    private static final RestParams EMPTY = RestParams.newBuilder().build();
    private final ImmutableMap<String, Object> values;

    private RestParams(Map<String, Object> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RestParams empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public ImmutableMap<String, Object> getValues() {
        return this.values;
    }

    public String getQueryString() {
        return RestParams.toQueryString(this.values);
    }

    public static String toQueryString(Map<String, Object> params) {
        return params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("&"));
    }

    @NotThreadSafe
    public static final class Builder {
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder add(String key, long value) {
            this.values.put(key, value);
            return this;
        }

        public Builder add(String key, double value) {
            return this.add(key, BigDecimal.valueOf(value).toPlainString());
        }

        public Builder add(String key, boolean value) {
            this.values.put(key, value);
            return this;
        }

        public Builder add(String key, String value) {
            this.values.put(key, value);
            return this;
        }

        public Builder addAll(Map<String, ?> values) {
            this.values.putAll(values);
            return this;
        }

        public RestParams build() {
            return new RestParams(this.values);
        }
    }
}

