/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.ratelimit;

import com.google.common.base.Preconditions;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitQuotaInterceptor;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottle;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitCache;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SimpleRateLimitThrottle
implements IRateLimitThrottle {
    private final String boundLocalAddress;
    private final String apiKeyId;
    private final RateLimitCache cache;
    private final IRateLimitQuotaInterceptor interceptor;

    SimpleRateLimitThrottle(String boundLocalAddress, @Nullable String apiKeyId, RateLimitCache cache, @Nullable IRateLimitQuotaInterceptor interceptor) {
        this.boundLocalAddress = boundLocalAddress;
        this.apiKeyId = apiKeyId;
        this.cache = cache;
        this.interceptor = interceptor;
    }

    @Override
    public void acquire(String requestName, List<RateLimitQuota> quota) {
        if (this.interceptor != null) {
            quota = (List)this.interceptor.apply(requestName, quota);
        }
        quota.forEach(this::acquire);
    }

    private void acquire(RateLimitQuota quota) {
        Preconditions.checkArgument((quota.getPermits() > 0 ? 1 : 0) != 0);
        switch (quota.getType()) {
            case IP: {
                this.cache.acquire(quota.getRuleName(), this.boundLocalAddress, quota.getPermits());
                break;
            }
            case API_KEY: {
                if (this.apiKeyId == null) {
                    throw new IllegalArgumentException();
                }
                this.cache.acquire(quota.getRuleName(), this.apiKeyId, quota.getPermits());
                break;
            }
            default: {
                throw new UnsupportedOperationException(quota.getType().name());
            }
        }
    }
}

