/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.ratelimit;

import com.google.common.collect.ImmutableMap;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitRule;
import io.github.resilience4j.ratelimiter.RateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RateLimitCache {
    private final ImmutableMap<String, RuleBasedLimiter> rules;

    private RateLimitCache(ImmutableMap<String, RuleBasedLimiter> rules) {
        this.rules = rules;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    void acquire(String ruleName, String key, int permits) {
        ((RuleBasedLimiter)this.rules.get((Object)ruleName)).acquire(key, permits);
    }

    @NotThreadSafe
    public static final class Builder {
        private final List<RateLimitRule> rules = new ArrayList<RateLimitRule>();

        public Builder addRule(RateLimitRule rule) {
            this.rules.add(rule);
            return this;
        }

        public RateLimitCache build() {
            return new RateLimitCache((ImmutableMap)this.rules.stream().collect(ImmutableMap.toImmutableMap(RateLimitRule::getName, x$0 -> new RuleBasedLimiter((RateLimitRule)x$0))));
        }
    }

    @ThreadSafe
    private static final class RuleBasedLimiter {
        private final RateLimitRule rule;
        private final Map<String, RateLimiter> limiters = new HashMap<String, RateLimiter>();

        private RuleBasedLimiter(RateLimitRule rule) {
            this.rule = rule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire(String key, int permits) {
            Map<String, RateLimiter> map = this.limiters;
            synchronized (map) {
                RateLimiter limiter = this.limiters.computeIfAbsent(key, this.rule::createRateLimiter);
                limiter.acquirePermission(permits);
            }
        }
    }
}

