/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.http;

import io.contek.invoker.commons.api.actor.http.HttpLoggingInterceptor;
import io.contek.invoker.commons.api.actor.http.IHttpClient;
import io.contek.invoker.commons.api.actor.http.IHttpClientFactory;
import io.contek.invoker.commons.api.actor.http.IHttpContext;
import io.contek.invoker.commons.api.actor.http.SimpleHttpClient;
import java.net.InetAddress;
import java.time.Duration;
import javax.annotation.concurrent.Immutable;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

@Immutable
public final class SimpleHttpClientFactory
implements IHttpClientFactory {
    private static final InetAddress LOCAL_HOST = InetAddress.getLoopbackAddress();

    private SimpleHttpClientFactory() {
    }

    public static SimpleHttpClientFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public IHttpClient create(IHttpContext context) {
        Duration pingInterval;
        Duration writeTimeout;
        Duration readTimeout;
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().addInterceptor((Interceptor)HttpLoggingInterceptor.getInstance());
        Duration connectionTimeout = context.getConnectionTimeout();
        if (connectionTimeout != null) {
            builder.connectTimeout(connectionTimeout);
        }
        if ((readTimeout = context.getReadTimeout()) != null) {
            builder.readTimeout(readTimeout);
        }
        if ((writeTimeout = context.getWriteTimeout()) != null) {
            builder.writeTimeout(writeTimeout);
        }
        if ((pingInterval = context.getPingInterval()) != null) {
            builder.pingInterval(pingInterval);
        }
        return new SimpleHttpClient(builder.build(), LOCAL_HOST);
    }

    @Immutable
    private static final class InstanceHolder {
        private static final SimpleHttpClientFactory INSTANCE = new SimpleHttpClientFactory();

        private InstanceHolder() {
        }
    }
}

