/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.http;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpLoggingInterceptor.class);

    public static HttpLoggingInterceptor getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpLoggingInterceptor.logRequest(request);
        Response response = chain.proceed(request);
        HttpLoggingInterceptor.logResponse(request, response);
        return response;
    }

    private static void logRequest(Request request) {
        RequestBody body = request.body();
        if (body == null) {
            log.info("Sending {} request to {}.", (Object)request.method(), (Object)request.url());
        } else {
            String bodyString = HttpLoggingInterceptor.readString(body);
            log.info("Sending {} request to {} with payload {}.", new Object[]{request.method(), request.url(), bodyString});
        }
    }

    private static void logResponse(Request request, Response response) {
        ResponseBody body = response.body();
        if (body == null) {
            log.info("Received {} response from {}.", (Object)request.method(), (Object)request.url());
        } else {
            String bodyString = HttpLoggingInterceptor.readString(body);
            log.info("Received {} response from {} with payload {}.", new Object[]{request.method(), request.url(), bodyString});
        }
    }

    private static String readString(RequestBody body) {
        try {
            Buffer buffer = new Buffer();
            body.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private static String readString(ResponseBody body) {
        try {
            BufferedSource source = body.source();
            source.request(Integer.MAX_VALUE);
            ByteString bytes = source.getBuffer().snapshot();
            return bytes.utf8();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private HttpLoggingInterceptor() {
    }

    @Immutable
    private static final class InstanceHolder {
        private static final HttpLoggingInterceptor INSTANCE = new HttpLoggingInterceptor();

        private InstanceHolder() {
        }
    }
}

