/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor;

import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.IActorFactory;
import io.contek.invoker.commons.api.actor.SimpleActor;
import io.contek.invoker.commons.api.actor.http.IHttpClient;
import io.contek.invoker.commons.api.actor.http.IHttpClientFactory;
import io.contek.invoker.commons.api.actor.http.IHttpContext;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottle;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottleFactory;
import io.contek.invoker.security.ApiKey;
import io.contek.invoker.security.ICredential;
import io.contek.invoker.security.ICredentialFactory;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SimpleActorFactory
implements IActorFactory {
    private final ICredentialFactory credentialFactory;
    private final IHttpClientFactory httpClientFactory;
    private final IRateLimitThrottleFactory rateLimitThrottleFactory;

    private SimpleActorFactory(ICredentialFactory credentialFactory, IHttpClientFactory httpClientFactory, IRateLimitThrottleFactory rateLimitThrottleFactory) {
        this.credentialFactory = credentialFactory;
        this.httpClientFactory = httpClientFactory;
        this.rateLimitThrottleFactory = rateLimitThrottleFactory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public IActor create(@Nullable ApiKey apiKey, IHttpContext context) {
        ICredential.Anonymous credential = apiKey == null ? ICredential.anonymous() : this.credentialFactory.create(apiKey);
        IHttpClient httpClient = this.httpClientFactory.create(context);
        IRateLimitThrottle rateLimitThrottle = this.rateLimitThrottleFactory.create(httpClient.getBoundLocalAddress(), apiKey == null ? null : apiKey.getId());
        return new SimpleActor((ICredential)credential, httpClient, rateLimitThrottle);
    }

    @NotThreadSafe
    public static final class Builder {
        private ICredentialFactory credentialFactory;
        private IHttpClientFactory httpClientFactory;
        private IRateLimitThrottleFactory rateLimitThrottleFactory;

        public Builder setCredentialFactory(ICredentialFactory credentialFactory) {
            this.credentialFactory = credentialFactory;
            return this;
        }

        public Builder setHttpClientFactory(IHttpClientFactory httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        public Builder setRateLimitThrottleFactory(IRateLimitThrottleFactory rateLimitThrottleFactory) {
            this.rateLimitThrottleFactory = rateLimitThrottleFactory;
            return this;
        }

        public SimpleActorFactory build() {
            if (this.credentialFactory == null) {
                throw new IllegalArgumentException("No credential factory specified");
            }
            if (this.httpClientFactory == null) {
                throw new IllegalArgumentException("No http client factory specified");
            }
            if (this.rateLimitThrottleFactory == null) {
                throw new IllegalArgumentException("No rate limit throttle factory specified");
            }
            return new SimpleActorFactory(this.credentialFactory, this.httpClientFactory, this.rateLimitThrottleFactory);
        }

        private Builder() {
        }
    }
}

