/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.websocket.market;

import io.contek.invoker.bybit.api.websocket.WebSocketChannel;
import io.contek.invoker.bybit.api.websocket.common.WebSocketTopicMessage;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TradeChannel
extends WebSocketChannel<Message> {
    public static final String TOPIC_PREFIX = "trade";
    private final String topic;

    public TradeChannel(String symbol) {
        this.topic = "trade." + symbol;
    }

    @Override
    protected String getTopic() {
        return this.topic;
    }

    protected Class<Message> getMessageType() {
        return Message.class;
    }

    protected boolean accepts(Message message) {
        return this.topic.equals(message.topic);
    }

    @NotThreadSafe
    public static final class Message
    extends WebSocketTopicMessage {
        public ArrayList<Trade> data;
    }

    @NotThreadSafe
    public static final class Trade {
        public String timestamp;
        public Long trade_time_ms;
        public String symbol;
        public String side;
        public Double size;
        public Double price;
        public String tick_direction;
        public String trade_id;
        public Long cross_seq;
    }
}

