/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.contek.invoker.bybit.api.websocket.common.WebSocketRequestConfirmation;
import io.contek.invoker.bybit.api.websocket.market.OrderBookChannel;
import io.contek.invoker.bybit.api.websocket.market.TradeChannel;
import io.contek.invoker.commons.api.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.api.websocket.IWebSocketMessageParser;
import javax.annotation.concurrent.Immutable;

@Immutable
final class WebSocketMessageParser
implements IWebSocketMessageParser {
    private final Gson gson = new Gson();

    static WebSocketMessageParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public AnyWebSocketMessage parse(String text) {
        JsonElement json = (JsonElement)this.gson.fromJson(text, JsonElement.class);
        if (!json.isJsonObject()) {
            throw new IllegalArgumentException(text);
        }
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("topic")) {
            return this.toTopicMessage(obj);
        }
        if (obj.has("request")) {
            return this.toRequestConfirmation(obj);
        }
        throw new IllegalArgumentException(text);
    }

    private AnyWebSocketMessage toTopicMessage(JsonObject obj) {
        String topic = obj.get("topic").getAsString();
        if (topic.startsWith("orderBook_200.100ms") || topic.startsWith("orderBook_25")) {
            switch (obj.get("type").getAsString()) {
                case "snapshot": {
                    return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, OrderBookChannel.SnapshotMessage.class);
                }
                case "delta": {
                    return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, OrderBookChannel.DeltaMessage.class);
                }
            }
            throw new IllegalStateException();
        }
        if (topic.startsWith("trade")) {
            return (AnyWebSocketMessage)this.gson.fromJson((JsonElement)obj, TradeChannel.Message.class);
        }
        throw new IllegalArgumentException(obj.toString());
    }

    private WebSocketRequestConfirmation toRequestConfirmation(JsonObject obj) {
        return (WebSocketRequestConfirmation)((Object)this.gson.fromJson((JsonElement)obj, WebSocketRequestConfirmation.class));
    }

    private WebSocketMessageParser() {
    }

    @Immutable
    private static final class InstanceHolder {
        private static final WebSocketMessageParser INSTANCE = new WebSocketMessageParser();

        private InstanceHolder() {
        }
    }
}

