/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.websocket;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.bybit.api.websocket.common.WebSocketRequest;
import io.contek.invoker.bybit.api.websocket.common.WebSocketRequestConfirmation;
import io.contek.invoker.bybit.api.websocket.common.WebSocketTopicMessage;
import io.contek.invoker.commons.api.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.api.websocket.BaseWebSocketChannel;
import io.contek.invoker.commons.api.websocket.SubscriptionState;
import io.contek.invoker.commons.api.websocket.WebSocketSession;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class WebSocketChannel<Message extends WebSocketTopicMessage>
extends BaseWebSocketChannel<Message> {
    protected abstract String getTopic();

    protected final String getDisplayName() {
        return this.getTopic();
    }

    protected final SubscriptionState subscribe(WebSocketSession session) {
        WebSocketRequest request = new WebSocketRequest();
        request.op = "subscribe";
        request.args = ImmutableList.of((Object)this.getTopic());
        session.send((AnyWebSocketMessage)request);
        return SubscriptionState.SUBSCRIBING;
    }

    protected final SubscriptionState unsubscribe(WebSocketSession session) {
        WebSocketRequest request = new WebSocketRequest();
        request.op = "unsubscribe";
        request.args = ImmutableList.of((Object)this.getTopic());
        session.send((AnyWebSocketMessage)request);
        return SubscriptionState.UNSUBSCRIBING;
    }

    @Nullable
    protected final SubscriptionState getState(AnyWebSocketMessage message) {
        if (message instanceof WebSocketRequestConfirmation) {
            WebSocketRequestConfirmation confirmation = (WebSocketRequestConfirmation)message;
            WebSocketRequest request = confirmation.request;
            if (!request.args.contains(this.getTopic())) {
                return null;
            }
            if (!confirmation.success.booleanValue()) {
                throw new IllegalStateException();
            }
            switch (request.op) {
                case "subscribe": {
                    return SubscriptionState.SUBSCRIBED;
                }
                case "unsubscribe": {
                    return SubscriptionState.UNSUBSCRIBED;
                }
            }
            throw new IllegalStateException();
        }
        return null;
    }

    protected final void reset() {
    }
}

