/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest.user;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.bybit.api.ApiFactory;
import io.contek.invoker.bybit.api.common._Order;
import io.contek.invoker.bybit.api.rest.common.RestPagedResult;
import io.contek.invoker.bybit.api.rest.common.RestResponse;
import io.contek.invoker.bybit.api.rest.user.UserRestRequest;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestMethod;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GetOrderList
extends UserRestRequest<Response> {
    private String symbol;
    private String order_status;
    private String direction;
    private Integer limit;
    private String cursor;

    GetOrderList(IActor actor, RestContext context) {
        super(actor, context);
    }

    public GetOrderList setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public GetOrderList setOrderStatus(@Nullable String order_status) {
        this.order_status = order_status;
        return this;
    }

    public GetOrderList setDirection(@Nullable String direction) {
        this.direction = direction;
        return this;
    }

    public GetOrderList setLimit(@Nullable Integer limit) {
        this.limit = limit;
        return this;
    }

    public GetOrderList setCursor(@Nullable String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Override
    protected RestMethod getMethod() {
        return RestMethod.GET;
    }

    @Override
    protected String getEndpointPath() {
        return "/v2/private/order/list";
    }

    @Override
    protected RestParams getParams() {
        RestParams.Builder builder = RestParams.newBuilder();
        Objects.requireNonNull(this.symbol);
        builder.add("symbol", this.symbol);
        if (this.order_status != null) {
            builder.add("order_status", this.order_status);
        }
        if (this.direction != null) {
            builder.add("direction", this.direction);
        }
        if (this.limit != null) {
            builder.add("limit", (long)this.limit.intValue());
        }
        if (this.cursor != null) {
            builder.add("cursor", this.cursor);
        }
        return builder.build();
    }

    protected ImmutableList<RateLimitQuota> getRequiredQuotas() {
        return ApiFactory.RateLimits.ONE_REST_PRIVATE_ORDER_READ_REQUEST;
    }

    protected Class<Response> getResponseType() {
        return Response.class;
    }

    @NotThreadSafe
    public static final class Response
    extends RestResponse<RestPagedResult<_Order>> {
    }
}

