/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.ParallelConsumer;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.CloseableIterator;

public class RetryQueue {
    private final Map<WorkContainerKey, WorkContainerSortKey> unique = new HashMap<WorkContainerKey, WorkContainerSortKey>();
    private final NavigableMap<WorkContainerSortKey, WorkContainer<?, ?>> sorted;
    private final Comparator<WorkContainerSortKey> comparator = Comparator.comparing(WorkContainerSortKey::getRetryDueAt).thenComparing(WorkContainerKey::getTopic).thenComparing(WorkContainerKey::getPartition).thenComparing(WorkContainerKey::getOffset);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    public RetryQueue() {
        this.sorted = new TreeMap(this.comparator);
    }

    public int size() {
        return this.unique.size();
    }

    public boolean isEmpty() {
        return this.unique.isEmpty();
    }

    public boolean contains(WorkContainer<?, ?> wc) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.unique.containsKey(WorkContainerKey.of(wc));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.unique.clear();
            this.sorted.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public RetryQueueIterator iterator() {
        this.lock.readLock().lock();
        return new RetryQueueIterator(this.lock, this.sorted.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(WorkContainer<?, ?> workContainer) {
        this.lock.writeLock().lock();
        try {
            WorkContainerKey newKey = WorkContainerKey.of(workContainer);
            WorkContainerSortKey newSortKey = WorkContainerSortKey.of(workContainer);
            WorkContainerSortKey existing = this.unique.put(newKey, newSortKey);
            if (existing != null) {
                this.sorted.remove(existing);
            }
            this.sorted.put(newSortKey, workContainer);
            boolean bl = existing == null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(WorkContainer<?, ?> workContainer) {
        this.lock.writeLock().lock();
        try {
            WorkContainerKey newKey = WorkContainerKey.of(workContainer);
            WorkContainerSortKey existing = this.unique.remove(newKey);
            if (existing != null) {
                this.sorted.remove(existing);
            }
            boolean bl = existing != null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> boolean removeAll(List<WorkContainer<K, V>> toRemove) {
        if (toRemove == null || this.unique.isEmpty()) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            List keysToRemove = toRemove.stream().map(WorkContainerKey::of).collect(Collectors.toList());
            boolean modified = false;
            for (WorkContainerKey wcKey : keysToRemove) {
                WorkContainerSortKey existing = this.unique.remove(wcKey);
                if (existing == null) continue;
                this.sorted.remove(existing);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public WorkContainer<?, ?> last() {
        this.lock.readLock().lock();
        try {
            WorkContainer<?, ?> workContainer = this.sorted.isEmpty() ? null : this.sorted.lastEntry().getValue();
            return workContainer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public WorkContainer<?, ?> first() {
        this.lock.readLock().lock();
        try {
            WorkContainer<?, ?> workContainer = this.sorted.isEmpty() ? null : this.sorted.firstEntry().getValue();
            return workContainer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ParallelConsumer.Tuple<Integer, Long> getQueueSizeAndNumberReadyToBeRetried() {
        this.lock.readLock().lock();
        try {
            ParallelConsumer.Tuple<Integer, Long> tuple = new ParallelConsumer.Tuple<Integer, Long>(this.sorted.size(), this.getNumberOfFailedWorkReadyToBeRetried());
            return tuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private long getNumberOfFailedWorkReadyToBeRetried() {
        WorkContainer workContainer;
        long count = 0L;
        if (Optional.ofNullable(this.sorted.isEmpty() ? null : this.sorted.lastEntry().getValue()).map(WorkContainer::isDelayPassed).orElse(false).booleanValue()) {
            return this.sorted.size();
        }
        Iterator iterator = this.sorted.values().iterator();
        while (iterator.hasNext() && (workContainer = (WorkContainer)iterator.next()).isDelayPassed()) {
            ++count;
        }
        return count;
    }

    Map<WorkContainerKey, WorkContainerSortKey> getUnique() {
        return this.unique;
    }

    NavigableMap<WorkContainerSortKey, WorkContainer<?, ?>> getSorted() {
        return this.sorted;
    }

    Comparator<WorkContainerSortKey> getComparator() {
        return this.comparator;
    }

    static class WorkContainerKey {
        private final String topic;
        private final Integer partition;
        private final Long offset;

        private WorkContainerKey(String topic, Integer partition, Long offset) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
        }

        static WorkContainerKey of(WorkContainer<?, ?> workContainer) {
            return new WorkContainerKey(workContainer.getTopicPartition().topic(), workContainer.getTopicPartition().partition(), workContainer.getCr().offset());
        }

        public String getTopic() {
            return this.topic;
        }

        public Integer getPartition() {
            return this.partition;
        }

        public Long getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkContainerKey)) {
                return false;
            }
            WorkContainerKey other = (WorkContainerKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$partition = this.getPartition();
            Integer other$partition = other.getPartition();
            if (this$partition == null ? other$partition != null : !((Object)this$partition).equals(other$partition)) {
                return false;
            }
            Long this$offset = this.getOffset();
            Long other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WorkContainerKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $partition = this.getPartition();
            result = result * 59 + ($partition == null ? 43 : ((Object)$partition).hashCode());
            Long $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }
    }

    public static class RetryQueueIterator
    implements CloseableIterator<WorkContainer<?, ?>> {
        private final ReentrantReadWriteLock lock;
        private final Iterator<WorkContainer<?, ?>> wrapped;
        private boolean closed;

        public RetryQueueIterator(ReentrantReadWriteLock lock, Iterator<WorkContainer<?, ?>> wrapped) {
            this.lock = lock;
            this.wrapped = wrapped;
            this.closed = false;
        }

        public void close() {
            this.lock.readLock().unlock();
            this.closed = true;
        }

        public boolean hasNext() {
            if (this.closed) {
                throw new IllegalStateException("RetryQueueIterator is closed");
            }
            return this.wrapped.hasNext();
        }

        public WorkContainer<?, ?> next() {
            if (this.closed) {
                throw new IllegalStateException("RetryQueueIterator is closed");
            }
            return this.wrapped.next();
        }
    }

    static class WorkContainerSortKey
    extends WorkContainerKey {
        private final Instant retryDueAt;

        private WorkContainerSortKey(String topic, Integer partition, Long offset, Instant retryDueAt) {
            super(topic, partition, offset);
            this.retryDueAt = retryDueAt;
        }

        static WorkContainerSortKey of(WorkContainer<?, ?> workContainer) {
            return new WorkContainerSortKey(workContainer.getTopicPartition().topic(), (Integer)workContainer.getTopicPartition().partition(), (Long)workContainer.getCr().offset(), workContainer.getRetryDueAt());
        }

        public Instant getRetryDueAt() {
            return this.retryDueAt;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkContainerSortKey)) {
                return false;
            }
            WorkContainerSortKey other = (WorkContainerSortKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Instant this$retryDueAt = this.getRetryDueAt();
            Instant other$retryDueAt = other.getRetryDueAt();
            return !(this$retryDueAt == null ? other$retryDueAt != null : !((Object)this$retryDueAt).equals(other$retryDueAt));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof WorkContainerSortKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Instant $retryDueAt = this.getRetryDueAt();
            result = result * 59 + ($retryDueAt == null ? 43 : ((Object)$retryDueAt).hashCode());
            return result;
        }
    }
}

