/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import java.nio.ByteBuffer;

public class ByteBufferEncoder
extends OffsetEncoder {
    private final ByteBuffer bytesBuffer;

    public ByteBufferEncoder(long length, OffsetSimultaneousEncoder offsetSimultaneousEncoder) {
        super(offsetSimultaneousEncoder, OffsetEncoding.Version.v1);
        int safeCast = Math.toIntExact(length);
        this.bytesBuffer = ByteBuffer.allocate(1 + safeCast);
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        return OffsetEncoding.ByteArray;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        return OffsetEncoding.ByteArrayCompressed;
    }

    @Override
    public void encodeIncompleteOffset(long relativeOffset) {
        this.bytesBuffer.put((byte)0);
    }

    @Override
    public void encodeCompletedOffset(long relativeOffset) {
        this.bytesBuffer.put((byte)1);
    }

    @Override
    public byte[] serialise() {
        return this.bytesBuffer.array();
    }

    @Override
    public int getEncodedSize() {
        return this.bytesBuffer.capacity();
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.bytesBuffer.array();
    }

    @Override
    public String toString() {
        return "ByteBufferEncoder(super=" + super.toString() + ", bytesBuffer=" + this.bytesBuffer + ")";
    }
}

