/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class SupplierUtils {
    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        Objects.requireNonNull(delegate);
        AtomicReference value = new AtomicReference();
        return () -> {
            Object val = value.get();
            if (val == null) {
                AtomicReference atomicReference = value;
                synchronized (atomicReference) {
                    val = value.get();
                    if (val == null) {
                        val = Objects.requireNonNull(delegate.get());
                        value.set(val);
                    }
                }
            }
            return val;
        };
    }

    private SupplierUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

