/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;

public final class BackportUtils {
    public static long toSeconds(Duration duration) {
        return duration.toMillis() / 1000L;
    }

    public static boolean isEmpty(Optional<?> optional) {
        return !optional.isPresent();
    }

    public static boolean hasNo(Optional<?> optional) {
        return !optional.isPresent();
    }

    public static byte[] readFully(InputStream is) throws IOException {
        return BackportUtils.readFully(is, -1, true);
    }

    public static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
        int cc;
        byte[] output = new byte[]{};
        if (length == -1) {
            length = Integer.MAX_VALUE;
        }
        for (int pos = 0; pos < length; pos += cc) {
            int bytesToRead;
            if (pos >= output.length) {
                bytesToRead = Math.min(length - pos, output.length + 1024);
                if (output.length < pos + bytesToRead) {
                    output = Arrays.copyOf(output, pos + bytesToRead);
                }
            } else {
                bytesToRead = output.length - pos;
            }
            if ((cc = is.read(output, pos, bytesToRead)) >= 0) continue;
            if (readAll && length != Integer.MAX_VALUE) {
                throw new EOFException("Detect premature EOF");
            }
            if (output.length == pos) break;
            output = Arrays.copyOf(output, pos);
            break;
        }
        return output;
    }

    private BackportUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

