/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.PollContextInternal;
import io.confluent.parallelconsumer.RecordContext;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.internal.ProducerManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkContainer<K, V>
implements Comparable<WorkContainer<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(WorkContainer.class);
    static final String DEFAULT_TYPE = "DEFAULT";
    @NonNull
    private final PCModule<K, V> module;
    private final long epoch;
    private String workType;
    private final ConsumerRecord<K, V> cr;
    private int numberOfFailedAttempts = 0;
    private Optional<Instant> lastFailedAt = Optional.empty();
    private Optional<Instant> succeededAt = Optional.empty();
    private Optional<Throwable> lastFailureReason;
    private boolean inFlight = false;
    private Optional<Boolean> maybeUserFunctionSucceeded = Optional.empty();
    private Future<List<?>> future;
    private Optional<Long> timeTakenAsWorkMs = Optional.empty();

    public WorkContainer(long epoch, ConsumerRecord<K, V> cr, @NonNull PCModule<K, V> module, @NonNull String workType) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (workType == null) {
            throw new NullPointerException("workType is marked non-null but is null");
        }
        this.epoch = epoch;
        this.cr = cr;
        this.workType = workType;
        this.module = module;
    }

    public WorkContainer(long epoch, ConsumerRecord<K, V> cr, PCModule<K, V> module) {
        this(epoch, cr, module, DEFAULT_TYPE);
    }

    public void endFlight() {
        log.trace("Ending flight {}", (Object)this);
        this.inFlight = false;
    }

    public boolean isDelayPassed() {
        if (!this.hasPreviouslyFailed()) {
            return true;
        }
        Duration delay = this.getDelayUntilRetryDue();
        boolean negative = delay.isNegative() || delay.isZero();
        return negative;
    }

    public Duration getDelayUntilRetryDue() {
        Instant now = this.module.clock().instant();
        Instant nextAttemptAt = this.getRetryDueAt();
        return Duration.between(now, nextAttemptAt);
    }

    public Instant getRetryDueAt() {
        if (this.lastFailedAt.isPresent()) {
            Duration retryDelay = this.getRetryDelayConfig();
            return this.lastFailedAt.get().plus(retryDelay);
        }
        return Instant.MIN;
    }

    public Duration getRetryDelayConfig() {
        ParallelConsumerOptions<K, V> options = this.module.options();
        Function<RecordContext<K, V>, Duration> retryDelayProvider = options.getRetryDelayProvider();
        if (retryDelayProvider != null) {
            return retryDelayProvider.apply(new RecordContext(this));
        }
        return options.getDefaultMessageRetryDelay();
    }

    @Override
    public int compareTo(WorkContainer o) {
        long myOffset = this.cr.offset();
        long theirOffset = o.cr.offset();
        int compare = Long.compare(myOffset, theirOffset);
        return compare;
    }

    public boolean isNotInFlight() {
        return !this.isInFlight();
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public void onQueueingForExecution() {
        log.trace("Queueing for execution: {}", (Object)this);
        this.inFlight = true;
        this.timeTakenAsWorkMs = Optional.of(System.currentTimeMillis());
    }

    public TopicPartition getTopicPartition() {
        return KafkaUtils.toTopicPartition(this.getCr());
    }

    public void onUserFunctionSuccess() {
        this.succeededAt = Optional.of(this.module.clock().instant());
        this.maybeUserFunctionSucceeded = Optional.of(true);
    }

    public void onUserFunctionFailure(Throwable cause) {
        log.trace("Failing {}", (Object)this);
        this.updateFailureHistory(cause);
        this.maybeUserFunctionSucceeded = Optional.of(false);
    }

    private void updateFailureHistory(Throwable cause) {
        ++this.numberOfFailedAttempts;
        this.lastFailedAt = Optional.of(Instant.now(this.module.clock()));
        this.lastFailureReason = Optional.ofNullable(cause);
    }

    public boolean isUserFunctionComplete() {
        return this.getMaybeUserFunctionSucceeded().isPresent();
    }

    public boolean isUserFunctionSucceeded() {
        Optional<Boolean> userFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        return userFunctionSucceeded.orElse(false);
    }

    public String toString() {
        return "WorkContainer(tp:" + KafkaUtils.toTopicPartition(this.cr) + ":o:" + this.cr.offset() + ":k:" + this.cr.key() + ")";
    }

    public Duration getTimeInFlight() {
        if (!this.timeTakenAsWorkMs.isPresent()) {
            return Duration.ZERO;
        }
        long millis = System.currentTimeMillis() - this.timeTakenAsWorkMs.get();
        return Duration.ofMillis(millis);
    }

    public long offset() {
        return this.getCr().offset();
    }

    public boolean hasPreviouslyFailed() {
        return this.getNumberOfFailedAttempts() > 0;
    }

    public boolean isAvailableToTakeAsWork() {
        return this.isNotInFlight() && !this.isUserFunctionSucceeded() && this.isDelayPassed();
    }

    public void onPostAddToMailBox(PollContextInternal<K, V> context, Optional<ProducerManager<K, V>> producerManager) {
        producerManager.ifPresent(pm -> {
            Optional<ProducerManager.ProducingLock> producingLock = context.getProducingLock();
            producingLock.ifPresent(pm::finishProducing);
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkContainer)) {
            return false;
        }
        WorkContainer other = (WorkContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getNumberOfFailedAttempts() != other.getNumberOfFailedAttempts()) {
            return false;
        }
        if (this.isInFlight() != other.isInFlight()) {
            return false;
        }
        PCModule<K, V> this$module = this.module;
        PCModule<K, V> other$module = other.module;
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$workType = this.getWorkType();
        String other$workType = other.getWorkType();
        if (this$workType == null ? other$workType != null : !this$workType.equals(other$workType)) {
            return false;
        }
        ConsumerRecord<K, V> this$cr = this.getCr();
        ConsumerRecord<K, V> other$cr = other.getCr();
        if (this$cr == null ? other$cr != null : !this$cr.equals(other$cr)) {
            return false;
        }
        Optional<Instant> this$lastFailedAt = this.getLastFailedAt();
        Optional<Instant> other$lastFailedAt = other.getLastFailedAt();
        if (this$lastFailedAt == null ? other$lastFailedAt != null : !((Object)this$lastFailedAt).equals(other$lastFailedAt)) {
            return false;
        }
        Optional<Instant> this$succeededAt = this.getSucceededAt();
        Optional<Instant> other$succeededAt = other.getSucceededAt();
        if (this$succeededAt == null ? other$succeededAt != null : !((Object)this$succeededAt).equals(other$succeededAt)) {
            return false;
        }
        Optional<Throwable> this$lastFailureReason = this.getLastFailureReason();
        Optional<Throwable> other$lastFailureReason = other.getLastFailureReason();
        if (this$lastFailureReason == null ? other$lastFailureReason != null : !((Object)this$lastFailureReason).equals(other$lastFailureReason)) {
            return false;
        }
        Optional<Boolean> this$maybeUserFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        Optional<Boolean> other$maybeUserFunctionSucceeded = other.getMaybeUserFunctionSucceeded();
        if (this$maybeUserFunctionSucceeded == null ? other$maybeUserFunctionSucceeded != null : !((Object)this$maybeUserFunctionSucceeded).equals(other$maybeUserFunctionSucceeded)) {
            return false;
        }
        Future<List<?>> this$future = this.getFuture();
        Future<List<?>> other$future = other.getFuture();
        if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
            return false;
        }
        Optional<Long> this$timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        Optional<Long> other$timeTakenAsWorkMs = other.timeTakenAsWorkMs;
        return !(this$timeTakenAsWorkMs == null ? other$timeTakenAsWorkMs != null : !((Object)this$timeTakenAsWorkMs).equals(other$timeTakenAsWorkMs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        result = result * 59 + this.getNumberOfFailedAttempts();
        result = result * 59 + (this.isInFlight() ? 79 : 97);
        PCModule<K, V> $module = this.module;
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $workType = this.getWorkType();
        result = result * 59 + ($workType == null ? 43 : $workType.hashCode());
        ConsumerRecord<K, V> $cr = this.getCr();
        result = result * 59 + ($cr == null ? 43 : $cr.hashCode());
        Optional<Instant> $lastFailedAt = this.getLastFailedAt();
        result = result * 59 + ($lastFailedAt == null ? 43 : ((Object)$lastFailedAt).hashCode());
        Optional<Instant> $succeededAt = this.getSucceededAt();
        result = result * 59 + ($succeededAt == null ? 43 : ((Object)$succeededAt).hashCode());
        Optional<Throwable> $lastFailureReason = this.getLastFailureReason();
        result = result * 59 + ($lastFailureReason == null ? 43 : ((Object)$lastFailureReason).hashCode());
        Optional<Boolean> $maybeUserFunctionSucceeded = this.getMaybeUserFunctionSucceeded();
        result = result * 59 + ($maybeUserFunctionSucceeded == null ? 43 : ((Object)$maybeUserFunctionSucceeded).hashCode());
        Future<List<?>> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        Optional<Long> $timeTakenAsWorkMs = this.timeTakenAsWorkMs;
        result = result * 59 + ($timeTakenAsWorkMs == null ? 43 : ((Object)$timeTakenAsWorkMs).hashCode());
        return result;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public String getWorkType() {
        return this.workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public ConsumerRecord<K, V> getCr() {
        return this.cr;
    }

    public int getNumberOfFailedAttempts() {
        return this.numberOfFailedAttempts;
    }

    public Optional<Instant> getLastFailedAt() {
        return this.lastFailedAt;
    }

    public Optional<Instant> getSucceededAt() {
        return this.succeededAt;
    }

    public Optional<Throwable> getLastFailureReason() {
        return this.lastFailureReason;
    }

    public Optional<Boolean> getMaybeUserFunctionSucceeded() {
        return this.maybeUserFunctionSucceeded;
    }

    public Future<List<?>> getFuture() {
        return this.future;
    }

    public void setFuture(Future<List<?>> future) {
        this.future = future;
    }
}

