/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.PollContext;
import io.confluent.parallelconsumer.RecordContext;
import io.confluent.parallelconsumer.RecordContextInternal;
import io.confluent.parallelconsumer.internal.ProducerManager;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class PollContextInternal<K, V> {
    private final PollContext<K, V> pollContext;
    protected Optional<ProducerManager.ProducingLock> producingLock = Optional.empty();

    public PollContextInternal(List<WorkContainer<K, V>> workContainers) {
        this.pollContext = new PollContext<K, V>(workContainers);
    }

    public Stream<WorkContainer<K, V>> streamWorkContainers() {
        return this.pollContext.streamInternal().map(RecordContextInternal::getWorkContainer);
    }

    public List<WorkContainer<K, V>> getWorkContainers() {
        return this.streamWorkContainers().collect(Collectors.toList());
    }

    public String toString() {
        return "PollContextInternal(pollContext=" + this.getPollContext() + ", producingLock=" + this.getProducingLock() + ")";
    }

    public PollContext<K, V> getPollContext() {
        return this.pollContext;
    }

    public Optional<ProducerManager.ProducingLock> getProducingLock() {
        return this.producingLock;
    }

    public void setProducingLock(Optional<ProducerManager.ProducingLock> producingLock) {
        this.producingLock = producingLock;
    }

    public Stream<RecordContextInternal<K, V>> streamInternal() {
        return this.getPollContext().streamInternal();
    }

    public Stream<RecordContext<K, V>> stream() {
        return this.getPollContext().stream();
    }

    public Stream<ConsumerRecord<K, V>> streamConsumerRecords() {
        return this.getPollContext().streamConsumerRecords();
    }

    public RecordContext<K, V> getSingleRecord() {
        return this.getPollContext().getSingleRecord();
    }

    public ConsumerRecord<K, V> getSingleConsumerRecord() {
        return this.getPollContext().getSingleConsumerRecord();
    }

    public V value() {
        return this.getPollContext().value();
    }

    public K key() {
        return this.getPollContext().key();
    }

    public long offset() {
        return this.getPollContext().offset();
    }

    public List<RecordContext<K, V>> getContextsFlattened() {
        return this.getPollContext().getContextsFlattened();
    }

    public List<ConsumerRecord<K, V>> getConsumerRecordsFlattened() {
        return this.getPollContext().getConsumerRecordsFlattened();
    }

    public Iterator<RecordContext<K, V>> iterator() {
        return this.getPollContext().iterator();
    }

    public void forEach(Consumer<? super RecordContext<K, V>> action) {
        this.getPollContext().forEach((Consumer<RecordContext<K, V>>)action);
    }

    public Spliterator<RecordContext<K, V>> spliterator() {
        return this.getPollContext().spliterator();
    }

    public Map<TopicPartition, Set<RecordContext<K, V>>> getByTopicPartitionMap() {
        return this.getPollContext().getByTopicPartitionMap();
    }

    public long size() {
        return this.getPollContext().size();
    }

    public List<Long> getOffsetsFlattened() {
        return this.getPollContext().getOffsetsFlattened();
    }

    public Map<TopicPartition, List<Long>> getOffsets() {
        return this.getPollContext().getOffsets();
    }
}

