/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.RecordContext;
import io.confluent.parallelconsumer.RecordContextInternal;
import io.confluent.parallelconsumer.internal.Documentation;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class PollContext<K, V>
implements Iterable<RecordContext<K, V>> {
    protected final Map<TopicPartition, Set<RecordContextInternal<K, V>>> records = new HashMap<TopicPartition, Set<RecordContextInternal<K, V>>>();

    PollContext(List<WorkContainer<K, V>> workContainers) {
        for (WorkContainer<K, V> wc : workContainers) {
            TopicPartition topicPartition = wc.getTopicPartition();
            Set recordSet = this.records.computeIfAbsent(topicPartition, ignore -> new HashSet());
            recordSet.add(new RecordContextInternal<K, V>(wc));
        }
    }

    public Stream<RecordContextInternal<K, V>> streamInternal() {
        return this.records.values().stream().flatMap(Collection::stream);
    }

    public Stream<RecordContext<K, V>> stream() {
        return this.getByTopicPartitionMap().values().stream().flatMap(Collection::stream);
    }

    public Stream<ConsumerRecord<K, V>> streamConsumerRecords() {
        return this.stream().map(RecordContext::getConsumerRecord);
    }

    public RecordContext<K, V> getSingleRecord() {
        if (this.size() != 1L) {
            throw new IllegalArgumentException(StringUtils.msg("A 'batch size' has been specified in `options`, so you must use the `batch` versions of the polling methods. See {}", Documentation.getLinkHtmlToDocSection("#batching")));
        }
        return this.stream().findFirst().get();
    }

    public ConsumerRecord<K, V> getSingleConsumerRecord() {
        return this.getSingleRecord().getConsumerRecord();
    }

    public V value() {
        return (V)this.getSingleConsumerRecord().value();
    }

    public K key() {
        return (K)this.getSingleConsumerRecord().key();
    }

    public long offset() {
        return this.getSingleConsumerRecord().offset();
    }

    public List<RecordContext<K, V>> getContextsFlattened() {
        return this.records.values().stream().flatMap(Collection::stream).map(RecordContextInternal::getRecordContext).collect(Collectors.toList());
    }

    public List<ConsumerRecord<K, V>> getConsumerRecordsFlattened() {
        return this.streamConsumerRecords().collect(Collectors.toList());
    }

    @Override
    public Iterator<RecordContext<K, V>> iterator() {
        return this.stream().iterator();
    }

    @Override
    public void forEach(Consumer<? super RecordContext<K, V>> action) {
        Iterable.super.forEach(action);
    }

    @Override
    public Spliterator<RecordContext<K, V>> spliterator() {
        return Iterable.super.spliterator();
    }

    public Map<TopicPartition, Set<RecordContext<K, V>>> getByTopicPartitionMap() {
        return this.records.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, set -> ((Set)set.getValue()).stream().map(RecordContextInternal::getRecordContext).collect(Collectors.toSet())));
    }

    public long size() {
        return this.stream().count();
    }

    public List<Long> getOffsetsFlattened() {
        return this.streamConsumerRecords().mapToLong(ConsumerRecord::offset).boxed().collect(Collectors.toList());
    }

    public Map<TopicPartition, List<Long>> getOffsets() {
        return this.getByTopicPartitionMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(RecordContext::offset).collect(Collectors.toList())));
    }

    public PollContext() {
    }

    public String toString() {
        return "PollContext(records=" + this.records + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PollContext)) {
            return false;
        }
        PollContext other = (PollContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<TopicPartition, Set<RecordContextInternal<K, V>>> this$records = this.records;
        Map<TopicPartition, Set<RecordContextInternal<K, V>>> other$records = other.records;
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PollContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TopicPartition, Set<RecordContextInternal<K, V>>> $records = this.records;
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }
}

