/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.ParallelConsumerOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.TransactionManager;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerWrapper<K, V>
implements Producer<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ProducerWrapper.class);
    private volatile ProducerState producerState = ProducerState.INSTANTIATED;
    @NonNull
    private final ParallelConsumerOptions<K, V> options;
    private final boolean producerIsConfiguredForTransactions;
    private Field txManagerField;
    private Method txManagerMethodIsCompleting;
    private Method txManagerMethodIsReady;
    @NonNull
    private final Producer<K, V> producer;

    public ProducerWrapper(ParallelConsumerOptions<K, V> options) {
        this.options = options;
        this.producer = options.getProducer();
        this.producerIsConfiguredForTransactions = this.discoverIfProducerIsConfiguredForTransactions();
    }

    public boolean isMockProducer() {
        return this.producer instanceof MockProducer;
    }

    public boolean isConfiguredForTransactions() {
        return this.producerIsConfiguredForTransactions;
    }

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.sendOffsetsToTransaction(offsets, new ConsumerGroupMetadata(consumerGroupId));
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.producer.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    private boolean discoverIfProducerIsConfiguredForTransactions() {
        if (this.producer instanceof KafkaProducer) {
            this.txManagerField = this.producer.getClass().getDeclaredField("transactionManager");
            this.txManagerField.setAccessible(true);
            boolean producerIsConfiguredForTransactions = this.getProducerIsTransactional();
            if (producerIsConfiguredForTransactions) {
                TransactionManager transactionManager = this.getTransactionManager();
                this.txManagerMethodIsCompleting = transactionManager.getClass().getDeclaredMethod("isCompleting", new Class[0]);
                this.txManagerMethodIsCompleting.setAccessible(true);
                this.txManagerMethodIsReady = transactionManager.getClass().getDeclaredMethod("isReady", new Class[0]);
                this.txManagerMethodIsReady.setAccessible(true);
            }
            return producerIsConfiguredForTransactions;
        }
        if (this.producer instanceof MockProducer) {
            return this.options.isUsingTransactionalProducer();
        }
        return false;
    }

    private boolean getProducerIsTransactional() {
        if (this.producer instanceof MockProducer) {
            return this.options.isUsingTransactionalProducer();
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            return false;
        }
        return transactionManager.isTransactional();
    }

    private TransactionManager getTransactionManager() {
        if (this.txManagerField == null) {
            return null;
        }
        TransactionManager transactionManager = (TransactionManager)this.txManagerField.get(this.producer);
        return transactionManager;
    }

    protected boolean isTransactionCompleting() {
        if (this.producer instanceof MockProducer) {
            return false;
        }
        return (Boolean)this.txManagerMethodIsCompleting.invoke((Object)this.getTransactionManager(), new Object[0]);
    }

    protected boolean isTransactionReady() {
        if (this.producer instanceof MockProducer) {
            return true;
        }
        return (Boolean)this.txManagerMethodIsReady.invoke((Object)this.getTransactionManager(), new Object[0]);
    }

    public void initTransactions() {
        this.producer.initTransactions();
        this.producerState = ProducerState.INIT;
    }

    public void beginTransaction() throws ProducerFencedException {
        this.producer.beginTransaction();
        this.producerState = ProducerState.BEGIN;
    }

    public void commitTransaction() throws ProducerFencedException {
        log.debug("Committing transaction...");
        this.producer.commitTransaction();
        this.producerState = ProducerState.COMMIT;
    }

    public void abortTransaction() throws ProducerFencedException {
        this.producer.abortTransaction();
        this.producerState = ProducerState.ABORT;
    }

    public void close() {
        this.producer.close();
        this.producerState = ProducerState.CLOSE;
    }

    public void close(Duration timeout) {
        this.producer.close(timeout);
        this.producerState = ProducerState.CLOSE;
    }

    public boolean isTransactionOpen() {
        return this.producerState.equals((Object)ProducerState.BEGIN);
    }

    public ProducerWrapper(@NonNull ParallelConsumerOptions<K, V> options, boolean producerIsConfiguredForTransactions, @NonNull Producer<K, V> producer) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (producer == null) {
            throw new NullPointerException("producer is marked non-null but is null");
        }
        this.options = options;
        this.producerIsConfiguredForTransactions = producerIsConfiguredForTransactions;
        this.producer = producer;
    }

    public ProducerState getProducerState() {
        return this.producerState;
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> arg0) {
        return this.producer.send(arg0);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> arg0, Callback arg1) {
        return this.producer.send(arg0, arg1);
    }

    public void flush() {
        this.producer.flush();
    }

    public List<PartitionInfo> partitionsFor(String arg0) {
        return this.producer.partitionsFor(arg0);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.producer.metrics();
    }

    public static enum ProducerState {
        INSTANTIATED,
        INIT,
        BEGIN,
        COMMIT,
        ABORT,
        CLOSE;

    }

    static interface Excludes {
        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2) throws ProducerFencedException;

        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, ConsumerGroupMetadata var2) throws ProducerFencedException;
    }
}

