/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.internal.InternalRuntimeException;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetBitSet {
    private static final Logger log = LoggerFactory.getLogger(OffsetBitSet.class);

    static String deserialiseBitSetWrap(ByteBuffer wrap, OffsetEncoding.Version version) {
        int n;
        wrap.rewind();
        switch (version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                n = wrap.getShort();
                break;
            }
            case v2: {
                n = wrap.getInt();
            }
        }
        int originalBitsetSize = n;
        ByteBuffer slice = wrap.slice();
        return OffsetBitSet.deserialiseBitSet(originalBitsetSize, slice);
    }

    static String deserialiseBitSet(int originalBitsetSize, ByteBuffer s) {
        BitSet bitSet = BitSet.valueOf(s);
        StringBuilder result = new StringBuilder(bitSet.size());
        for (Long offset : Range.range(originalBitsetSize)) {
            if (bitSet.get(Math.toIntExact(offset))) {
                result.append('x');
                continue;
            }
            result.append('o');
        }
        return result.toString();
    }

    static OffsetMapCodecManager.HighestOffsetAndIncompletes deserialiseBitSetWrapToIncompletes(OffsetEncoding encoding, long baseOffset, ByteBuffer wrap) {
        int n;
        wrap.rewind();
        switch (encoding) {
            case BitSet: {
                n = wrap.getShort();
                break;
            }
            case BitSetV2: {
                n = wrap.getInt();
                break;
            }
            default: {
                throw new InternalRuntimeException("Invalid state");
            }
        }
        int originalBitsetSize = n;
        ByteBuffer slice = wrap.slice();
        SortedSet<Long> incompletes = OffsetBitSet.deserialiseBitSetToIncompletes(baseOffset, originalBitsetSize, slice);
        long highestSeenOffset = baseOffset + (long)originalBitsetSize - 1L;
        return OffsetMapCodecManager.HighestOffsetAndIncompletes.of(highestSeenOffset, incompletes);
    }

    static SortedSet<Long> deserialiseBitSetToIncompletes(long baseOffset, int originalBitsetSize, ByteBuffer inputBuffer) {
        BitSet bitSet = BitSet.valueOf(inputBuffer);
        TreeSet<Long> incompletes = new TreeSet<Long>();
        for (long relativeOffsetLong : Range.range(originalBitsetSize)) {
            int relativeOffset = Math.toIntExact(relativeOffsetLong);
            long offset = baseOffset + (long)relativeOffset;
            if (bitSet.get(relativeOffset)) {
                log.trace("Ignoring completed offset {}", (Object)relativeOffset);
                continue;
            }
            incompletes.add(offset);
        }
        return incompletes;
    }
}

