/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetRunLength {
    private static final Logger log = LoggerFactory.getLogger(OffsetRunLength.class);

    static List<Integer> runLengthEncode(String in) {
        AtomicInteger length = new AtomicInteger();
        AtomicBoolean previous = new AtomicBoolean(false);
        ArrayList<Integer> encoding = new ArrayList<Integer>();
        in.chars().forEachOrdered(bit -> {
            boolean bl;
            switch (bit) {
                case 111: {
                    bl = false;
                    break;
                }
                case 120: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(bit + " in " + in);
                }
            }
            boolean current = bl;
            if (previous.get() == current) {
                length.getAndIncrement();
            } else {
                previous.set(current);
                encoding.add(length.get());
                length.set(1);
            }
        });
        encoding.add(length.get());
        return encoding;
    }

    static String runLengthDecodeToString(List<Integer> in) {
        StringBuilder sb = new StringBuilder(in.size());
        boolean current = false;
        for (Integer i : in) {
            for (int x = 0; x < i; ++x) {
                if (current) {
                    sb.append('x');
                    continue;
                }
                sb.append('o');
            }
            current = !current;
        }
        return sb.toString();
    }

    static OffsetMapCodecManager.HighestOffsetAndIncompletes runLengthDecodeToIncompletes(OffsetEncoding encoding, long baseOffset, ByteBuffer in) {
        in.rewind();
        ShortBuffer v1ShortBuffer = in.asShortBuffer();
        IntBuffer v2IntegerBuffer = in.asIntBuffer();
        TreeSet<Long> incompletes = new TreeSet<Long>();
        long highestSeenOffset = baseOffset > 0L ? baseOffset - 1L : 0L;
        Supplier<Boolean> hasRemainingTest = () -> {
            Boolean bl;
            switch (encoding.version) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case v1: {
                    bl = v1ShortBuffer.hasRemaining();
                    break;
                }
                case v2: {
                    bl = v2IntegerBuffer.hasRemaining();
                }
            }
            return bl;
        };
        if (log.isTraceEnabled()) {
            ArrayList<Short> runlengths = new ArrayList<Short>();
            try {
                while (hasRemainingTest.get().booleanValue()) {
                    Number number;
                    switch (encoding.version) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case v1: {
                            number = v1ShortBuffer.get();
                            break;
                        }
                        case v2: {
                            number = v2IntegerBuffer.get();
                        }
                    }
                    Number runLength = number;
                    runlengths.add((Short)runLength);
                }
            }
            catch (BufferUnderflowException u) {
                log.error("Error decoding offsets", (Throwable)u);
            }
            log.debug("Unrolled runlengths: {}", runlengths);
            v1ShortBuffer.rewind();
            v2IntegerBuffer.rewind();
        }
        boolean currentRunLengthIsComplete = false;
        long currentOffset = baseOffset;
        while (hasRemainingTest.get().booleanValue()) {
            try {
                Number runLength;
                switch (encoding.version) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case v1: {
                        Number number = v1ShortBuffer.get();
                        break;
                    }
                    case v2: {
                        Number number = runLength = Integer.valueOf(v2IntegerBuffer.get());
                    }
                }
                if (currentRunLengthIsComplete) {
                    log.trace("Ignoring {} completed offset(s) (offset:{})", (Object)runLength, (Object)currentOffset);
                    highestSeenOffset = (currentOffset += runLength.longValue()) - 1L;
                } else {
                    log.trace("Adding {} incomplete offset(s) (starting with offset:{})", (Object)runLength, (Object)currentOffset);
                    int relativeOffset = 0;
                    while ((long)relativeOffset < runLength.longValue()) {
                        incompletes.add(currentOffset);
                        highestSeenOffset = currentOffset++;
                        ++relativeOffset;
                    }
                }
                log.trace("Highest seen: {}", (Object)highestSeenOffset);
            }
            catch (BufferUnderflowException u) {
                log.error("Error decoding offsets", (Throwable)u);
                throw u;
            }
            currentRunLengthIsComplete = !currentRunLengthIsComplete;
        }
        return OffsetMapCodecManager.HighestOffsetAndIncompletes.of(highestSeenOffset, incompletes);
    }

    static List<Integer> runLengthDeserialise(ByteBuffer in) {
        in.rewind();
        ShortBuffer shortBuffer = in.asShortBuffer();
        ArrayList<Integer> results = new ArrayList<Integer>(shortBuffer.capacity());
        while (shortBuffer.hasRemaining()) {
            results.add(Integer.valueOf(shortBuffer.get()));
        }
        return results;
    }

    private OffsetRunLength() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

