/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.MathUtils;
import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.internal.InternalRuntimeException;
import io.confluent.parallelconsumer.offsets.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitSetEncoder
extends OffsetEncoder {
    private static final Logger log = LoggerFactory.getLogger(BitSetEncoder.class);
    private static final OffsetEncoding.Version DEFAULT_VERSION = OffsetEncoding.Version.v2;
    public static final Integer MAX_LENGTH_ENCODABLE = Integer.MAX_VALUE;
    private final BitSet bitSet;
    private final long originalLength;
    private Optional<byte[]> encodedBytes = Optional.empty();

    public BitSetEncoder(long length, OffsetSimultaneousEncoder offsetSimultaneousEncoder, OffsetEncoding.Version newVersion) throws BitSetEncodingNotSupportedException {
        super(offsetSimultaneousEncoder, newVersion);
        try {
            this.bitSet = new BitSet(Math.toIntExact(length));
        }
        catch (ArithmeticException e) {
            throw new BitSetEncodingNotSupportedException("BitSet only supports " + MAX_LENGTH_ENCODABLE + " bits, but " + length + " were requested", e);
        }
        this.originalLength = length;
    }

    private ByteBuffer constructWrappedByteBuffer(long length, OffsetEncoding.Version newVersion) throws BitSetEncodingNotSupportedException {
        ByteBuffer byteBuffer;
        switch (newVersion) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                byteBuffer = this.initV1(length);
                break;
            }
            case v2: {
                byteBuffer = this.initV2(length);
            }
        }
        return byteBuffer;
    }

    private ByteBuffer initV2(long bitsetEntriesRequired) throws BitSetEncodingNotSupportedException {
        if (bitsetEntriesRequired > (long)MAX_LENGTH_ENCODABLE.intValue()) {
            throw new BitSetEncodingNotSupportedException(StringUtils.msg("BitSet V2 too long to encode, as length overflows Integer.MAX_VALUE. Length: {}. (max: {})", bitsetEntriesRequired, MAX_LENGTH_ENCODABLE));
        }
        int bytesRequiredForEntries = (int)Math.ceil((double)bitsetEntriesRequired / 8.0);
        int lengthEntryWidth = 4;
        int wrappedBufferLength = lengthEntryWidth + bytesRequiredForEntries + 1;
        ByteBuffer wrappedBitSetBytesBuffer = ByteBuffer.allocate(wrappedBufferLength);
        wrappedBitSetBytesBuffer.putInt(Math.toIntExact(bitsetEntriesRequired));
        return wrappedBitSetBytesBuffer;
    }

    private ByteBuffer initV1(long bitsetEntriesRequired) throws BitSetEncodingNotSupportedException {
        if (bitsetEntriesRequired > 32767L) {
            throw new BitSetEncodingNotSupportedException("Input too long to encode for BitSet V1, length overflows Short.MAX_VALUE: " + bitsetEntriesRequired + ". (max: " + Short.MAX_VALUE + ")");
        }
        int bytesRequiredForEntries = (int)Math.ceil((double)bitsetEntriesRequired / 8.0);
        int lengthEntryWidth = 2;
        int wrappedBufferLength = lengthEntryWidth + bytesRequiredForEntries + 1;
        ByteBuffer wrappedBitSetBytesBuffer = ByteBuffer.allocate(wrappedBufferLength);
        wrappedBitSetBytesBuffer.putShort(MathUtils.toShortExact(bitsetEntriesRequired));
        return wrappedBitSetBytesBuffer;
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                offsetEncoding = OffsetEncoding.BitSet;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.BitSetV2;
            }
        }
        return offsetEncoding;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                offsetEncoding = OffsetEncoding.BitSetCompressed;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.BitSetV2Compressed;
            }
        }
        return offsetEncoding;
    }

    @Override
    public void encodeIncompleteOffset(long relativeOffset) {
    }

    @Override
    public void encodeCompletedOffset(long relativeOffset) {
        this.bitSet.set(Math.toIntExact(relativeOffset));
    }

    @Override
    public byte[] serialise() throws BitSetEncodingNotSupportedException {
        byte[] bitSetArray = this.bitSet.toByteArray();
        ByteBuffer wrappedBitSetBytesBuffer = this.constructWrappedByteBuffer(this.originalLength, this.version);
        if (wrappedBitSetBytesBuffer.remaining() < bitSetArray.length) {
            throw new InternalRuntimeException("Not enough space in byte array");
        }
        try {
            wrappedBitSetBytesBuffer.put(bitSetArray);
        }
        catch (BufferOverflowException e) {
            throw new InternalRuntimeException("Error copying bitset into byte wrapper", e);
        }
        byte[] array = wrappedBitSetBytesBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }

    @Override
    public String toString() {
        return "BitSetEncoder(super=" + super.toString() + ", bitSet=" + this.getBitSet() + ", originalLength=" + this.originalLength + ", encodedBytes=" + Arrays.toString(this.getEncodedBytes()) + ")";
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }
}

