/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.metrics;

import io.confluent.parallelconsumer.metrics.PCMetricsDef;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCMetrics {
    private static final Logger log = LoggerFactory.getLogger(PCMetrics.class);
    private static PCMetrics instance;
    private MeterRegistry meterRegistry;
    private List<Meter.Id> registeredMeters = new ArrayList<Meter.Id>();
    private Iterable<Tag> commonTags;

    private PCMetrics(MeterRegistry meterRegistry, Iterable<Tag> commonTags) {
        this.meterRegistry = meterRegistry;
        this.commonTags = commonTags;
    }

    public static void initialize(MeterRegistry meterRegistry, Iterable<Tag> commonTags) {
        if (instance != null) {
            log.warn("Reinitializing PCMetrics without closing them first. Closing previous instance.");
            PCMetrics.close();
        }
        instance = new PCMetrics(meterRegistry, commonTags);
    }

    public static PCMetrics getInstance() {
        if (instance == null) {
            log.warn("Warning - trying to use PCMetrics without first initializing it with MeterRegistry. Default noop meter registry will be used.");
            PCMetrics.initialize((MeterRegistry)new CompositeMeterRegistry(), Collections.emptyList());
        }
        return instance;
    }

    public Counter getCounterFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        Counter counter = Counter.builder((String)metricDef.getName()).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(counter.getId());
        return counter;
    }

    public Timer getTimerFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        Timer timer = Timer.builder((String)metricDef.getName()).publishPercentiles(new double[]{0.0, 0.5, 0.75, 0.95, 0.99, 0.999}).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(timer.getId());
        return timer;
    }

    public <T> Gauge gaugeFromMetricDef(PCMetricsDef metricDef, T stateObject, ToDoubleFunction<T> valueFunction, Tag ... additionalTags) {
        Gauge gauge = Gauge.builder((String)metricDef.getName(), stateObject, valueFunction).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).strongReference(true).register(this.meterRegistry);
        this.registeredMeters.add(gauge.getId());
        return gauge;
    }

    public DistributionSummary getDistributionSummaryFromMetricDef(PCMetricsDef metricDef, Tag ... additionalTags) {
        DistributionSummary distributionSummary = DistributionSummary.builder((String)metricDef.getName()).publishPercentiles(new double[]{0.0, 0.5, 0.75, 0.95, 0.99, 0.999}).description(metricDef.getDescription()).tags(this.commonTags).tags((Iterable)metricDef.getSubsystemAsTagsOrEmpty()).tags(Arrays.asList(additionalTags)).register(this.meterRegistry);
        this.registeredMeters.add(distributionSummary.getId());
        return distributionSummary;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public static void close() {
        if (instance == null) {
            return;
        }
        log.debug("Resetting PCMetrics");
        MeterRegistry registry = instance.getMeterRegistry();
        PCMetrics.instance.registeredMeters.forEach(arg_0 -> ((MeterRegistry)registry).remove(arg_0));
        PCMetrics.instance.registeredMeters.clear();
        instance = null;
    }

    public static void removeMeter(Meter meter) {
        if (meter != null) {
            PCMetrics.removeMeter(meter.getId());
        }
    }

    public static void removeMeter(Meter.Id meterId) {
        log.debug("Removing meter: {}", (Object)meterId);
        if (instance != null) {
            instance.getMeterRegistry().remove(meterId);
            PCMetrics.instance.registeredMeters.remove(meterId);
        }
    }
}

